/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class Sprite {
    public int x = 0;
    public int y = 0;
    public BImage image = null;
    public Image lcduiImage = null;
    public int frame = 0;
    public int anim = 0;
    public long tick = 0L;
    public int speed = 0;
    public boolean enabled = true;
    public int tag = 0;
    private int velocityX = 0;
    private int velocityY = 0;
    private int eventFlags = 0;
    public static final int SPRITE_EVENT_EXIT_BOUND_BOX = 1;
    public static final int SPRITE_EVENT_TIMER_EXPIRED = 2;
    private int boundX;
    private int boundY;
    private int boundWidth;
    private int boundHeight;
    private long timerExpire = 0L;
    private int myElapsedTime = 0;
    private long lastTick = System.currentTimeMillis();
    private boolean advanceFrame = false;

    public Sprite() {
    }

    public Sprite(BImage image) {
        this.init(image, 0, 0);
    }

    public Sprite(Image lImage, int x, int y) {
        this.lcduiImage = lImage;
        this.x = x;
        this.y = y;
        this.enabled = true;
    }

    public Sprite(BImage image, int x, int y) {
        this.init(image, x, y);
    }

    public Sprite(BImage image, int x, int y, int speed) {
        this.init(image, x, y);
        this.speed = speed;
    }

    public void init(BImage image, int x, int y) {
        this.image = image;
        this.x = x;
        this.y = y;
        this.speed = 4 + Util.rnd(2);
        this.anim = 0;
        this.tick = 0L;
        this.frame = Util.rnd(image.maxFrame(this.anim));
        this.enabled = true;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public boolean play(boolean loop) {
        return this.play(this.anim, loop);
    }

    public boolean play(int index, boolean loop) {
        if (this.image != null && this.speed != -1) {
            if (this.anim != index) {
                this.anim = index;
                this.frame = 0;
            }
            int maxFrame = this.image.maxFrame(this.anim);
            if (TimeLord.TE != 0) {
                if (TimeLord.tickCount > this.tick) {
                    this.tick = TimeLord.tickCount + (long)Util.MUL(this.speed * 16, TimeLord.TE);
                    this.frame = loop ? Util.croll(this.frame + 1, 0, maxFrame) : Util.clamp(this.frame + 1, 0, maxFrame);
                }
            } else {
                this.theCompanion();
                if (this.advanceFrame) {
                    this.frame = loop ? Util.croll(this.frame + 1, 0, maxFrame) : Util.clamp(this.frame + 1, 0, maxFrame);
                }
            }
            if (this.frame == maxFrame) {
                return true;
            }
        }
        return false;
    }

    public void playCurrentAnim(int x, int y) {
        this.x = x;
        this.y = y;
        this.frame = 0;
    }

    private void theCompanion() {
        long nowTick = System.currentTimeMillis();
        this.advanceFrame = false;
        this.myElapsedTime = (int)(nowTick - this.lastTick);
        if (nowTick > this.tick) {
            this.tick = nowTick + (long)this.speed;
            this.advanceFrame = true;
        }
        if (this.timerExpire != 0L && nowTick > this.timerExpire) {
            this.eventFlags |= 2;
        }
        this.lastTick = nowTick;
    }

    public void paintCurrentAnim(GraphicsHelper gh) {
        if (this.image == null || !this.enabled) {
            return;
        }
        int maxFrame = this.image.maxFrame(this.anim);
        if (this.frame == maxFrame) {
            return;
        }
        if (TimeLord.TE != 0) {
            if (TimeLord.tickCount > this.tick) {
                this.tick = TimeLord.tickCount + (long)Util.MUL(this.speed * 16, TimeLord.TE);
                this.frame = Util.clamp(this.frame + 1, 0, maxFrame);
            }
        } else {
            this.theCompanion();
            this.frame = Util.clamp(this.frame + 1, 0, maxFrame);
        }
        this.image.paintSprite(gh, this.x, this.y, this.anim, this.frame);
    }

    public void paintCurrentFrameToggledTime(GraphicsHelper gh) {
        if (this.image != null && this.enabled) {
            this.frame = TimeLord.tickCount > this.tick ? 0 : 1;
            this.image.paintSprite(gh, this.x, this.y, this.anim, this.frame);
        }
    }

    public void scheduleToggleTime(int fromNowMillis) {
        this.timerExpire = TimeLord.TE != 0 ? TimeLord.tickCount + (long)fromNowMillis : System.currentTimeMillis() + (long)fromNowMillis;
    }

    public void paintCurrentFrame(GraphicsHelper gh) {
        if (this.image != null && this.enabled) {
            this.image.paintSprite(gh, this.x, this.y, this.anim, this.frame);
        }
    }

    public void paintCurrentFrameWithSprite(GraphicsHelper gh, Sprite s) {
        if (s.image != null && s.enabled) {
            s.image.paintSprite(gh, this.x, this.y, this.anim, this.frame);
        }
    }

    public void paintFrame(GraphicsHelper gh, int frame, int x, int y) {
        if (this.image != null && this.enabled) {
            this.image.paintSprite(gh, x, y, this.anim, frame);
        }
    }

    public int getWidth() {
        if (this.lcduiImage != null) {
            return this.lcduiImage.getWidth();
        }
        if (this.image != null && this.enabled) {
            return this.image.getImageWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.lcduiImage != null) {
            return this.lcduiImage.getHeight();
        }
        if (this.image != null) {
            return this.image.getImageHeight();
        }
        return 0;
    }

    public void paint(GraphicsHelper gh) {
        if (this.lcduiImage != null && this.enabled) {
            int width = this.lcduiImage.getWidth();
            int height = this.lcduiImage.getHeight();
            gh.blt(this.lcduiImage, this.x - width / 2, this.y - height / 2, width, height, 0, 0);
        } else if (this.image != null && this.enabled) {
            this.play(true);
            this.image.paintSprite(gh, this.x, this.y, this.anim, this.frame);
        }
    }

    public void paint(GraphicsHelper gh, int xPos, int yPos) {
        if (this.lcduiImage != null && this.enabled) {
            int width = this.lcduiImage.getWidth();
            int height = this.lcduiImage.getHeight();
            gh.blt(this.lcduiImage, xPos - width / 2, yPos - height / 2, width, height, 0, 0);
        } else if (this.image != null && this.enabled) {
            this.play(true);
            this.image.paintSprite(gh, xPos, yPos, this.anim, this.frame);
        }
    }

    public void setPos(int px, int py) {
        this.x = px;
        this.y = py;
    }

    public void move() {
        this.x += this.velocityX;
        this.y += this.velocityY;
        this.checkExitBoundBox();
    }

    public void setVelocity(int vx, int vy) {
        this.velocityX = vx;
        this.velocityY = vy;
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    public boolean eventCheck(int flag) {
        return (this.eventFlags & flag) == 1;
    }

    public void checkExitBoundBox() {
        int width;
        if (this.lcduiImage != null) {
            int height = this.lcduiImage.getHeight();
            width = this.lcduiImage.getWidth();
        } else {
            int height = this.image.getImageHeight();
            width = this.image.getImageWidth() / 2;
        }
        if (this.x + width < this.boundX) {
            this.eventFlags |= 1;
        } else if (this.x - width > this.boundX + this.boundWidth) {
            this.eventFlags |= 1;
        }
    }
}

