/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class BTWSoundPlayer {
    private InputStream inBGM;
    private InputStream inOwn;
    private InputStream inAttack;
    private InputStream inJetpack;
    private InputStream inDamaged;
    private Player pBGM;
    private Player pOwn;
    private Player pAttack;
    private Player pJetpack;
    private Player pDamaged;
    private VolumeControl vc;
    private boolean isMute = false;

    public BTWSoundPlayer() {
        try {
            this.inBGM = this.getClass().getResourceAsStream("/litegroo.mid");
            this.pBGM = Manager.createPlayer((InputStream)this.inBGM, (String)"audio/midi");
            this.pBGM.realize();
            this.pBGM.setLoopCount(-1);
            this.inOwn = this.getClass().getResourceAsStream("/LaguLogoOwnGames.mid");
            this.pOwn = Manager.createPlayer((InputStream)this.inOwn, (String)"audio/midi");
            this.pOwn.realize();
            this.inAttack = this.getClass().getResourceAsStream("/suaraAttack.mp3");
            this.pAttack = Manager.createPlayer((InputStream)this.inAttack, (String)"audio/mp3");
            this.pAttack.realize();
            this.inDamaged = this.getClass().getResourceAsStream("/damaged.mp3");
            this.pDamaged = Manager.createPlayer((InputStream)this.inDamaged, (String)"audio/mp3");
            this.pDamaged.realize();
            this.inJetpack = this.getClass().getResourceAsStream("/Country.mid");
            this.pJetpack = Manager.createPlayer((InputStream)this.inJetpack, (String)"audio/midi");
            this.pJetpack.realize();
            this.pJetpack.setLoopCount(-1);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void destroy() {
        this.stopAll();
        this.pOwn.close();
        this.pBGM.close();
        this.pJetpack.close();
        this.pAttack.close();
        this.pDamaged.close();
    }

    public void playOwn() {
        this.play(this.pOwn, 50);
    }

    public void stopOwn() {
        this.stop(this.pOwn);
    }

    public void playBGM() {
        this.play(this.pBGM, 50);
    }

    public void stopBGM() {
        this.stop(this.pBGM);
    }

    public void playJetpack() {
        this.play(this.pJetpack, 50);
    }

    public void stopJetpack() {
        this.stop(this.pJetpack);
    }

    public void playAttack() {
        this.play(this.pAttack, 50);
    }

    public void stopAttack() {
        this.stop(this.pAttack);
    }

    public void playDamaged() {
        this.play(this.pDamaged, 50);
    }

    public void stopDamaged() {
        this.stop(this.pDamaged);
    }

    public void stopAll() {
        this.stopOwn();
        this.stopBGM();
        this.stopAttack();
        this.stopJetpack();
        this.stopDamaged();
    }

    public void muteSound() {
        this.stopAll();
        this.isMute = true;
    }

    public void unMuteSound() {
        this.isMute = false;
    }

    private void play(Player p, int volume) {
        try {
            if (p != null && p.getState() == 400) {
                p.stop();
                p.deallocate();
            }
            this.vc = (VolumeControl)p.getControl("VolumeControl");
            if (this.vc != null) {
                if (this.isMute) {
                    this.vc.setLevel(0);
                } else {
                    this.vc.setLevel(volume);
                }
            }
            p.realize();
            p.prefetch();
            p.setMediaTime(-1L);
            if (!this.isMute) {
                p.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stop(Player p) {
        try {
            if (p != null) {
                p.stop();
                p.deallocate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

