/*
 * Decompiled with CFR 0.152.
 */
public class Sample {
    public static void h2v1_downsample(int output_cols, int output_rows, short[][] input_data, short[][] output_data) {
        int outrow = 0;
        while (outrow < output_rows) {
            int outcol = 0;
            int incol = 0;
            while (outcol < output_cols) {
                output_data[outrow][outcol] = (short)((input_data[outrow][incol] + input_data[outrow][incol + 1] + 1) / 2);
                ++outcol;
                incol += 2;
            }
            ++outrow;
        }
    }

    public static void h2v2_downsample(int output_cols, int output_rows, short[][] input_data, short[][] output_data) {
        int inrow = 0;
        int outrow = 0;
        while (outrow < output_rows) {
            int outcol = 0;
            int incol = 0;
            while (outcol < output_cols) {
                output_data[outrow][outcol] = (short)((input_data[inrow][incol] + input_data[inrow][incol + 1] + input_data[inrow + 1][incol] + input_data[inrow + 1][incol + 1] + 2) / 4);
                ++outcol;
                incol += 2;
            }
            inrow += 2;
            ++outrow;
        }
    }

    public static void fullsize_downsample(int output_cols, int output_rows, short[][] input_data, short[][] output_data) {
        int outrow = 0;
        while (outrow < output_rows) {
            int outcol = 0;
            while (outcol < output_cols) {
                output_data[outrow][outcol] = input_data[outrow][outcol];
                ++outcol;
            }
            ++outrow;
        }
    }

    public static void downsample(CompressInfo cinfo, int ci, int output_cols, int output_rows, short[][] input_data, short[][] output_data) {
        int v = cinfo.max_v_samp_factor / cinfo.comp_info[ci].v_samp_factor;
        int h = cinfo.max_h_samp_factor / cinfo.comp_info[ci].h_samp_factor;
        if (v == 1 && h == 1) {
            Sample.fullsize_downsample(output_cols, output_rows, input_data, output_data);
        } else if (h == 2 && v == 2) {
            Sample.h2v2_downsample(output_cols, output_rows, input_data, output_data);
        } else if (h == 2 && v == 1) {
            Sample.h2v1_downsample(output_cols, output_rows, input_data, output_data);
        } else {
            util.errexit("Down sample ratio not supported.");
        }
    }

    public static void edge_expand(CompressInfo cinfo, int input_cols, int input_rows, int output_cols, int output_rows, short[][][] image_data) {
        if (input_cols < output_cols) {
            int numcols = output_cols - input_cols;
            short ci = 0;
            while (ci < cinfo.num_components) {
                int row = 0;
                while (row < input_rows) {
                    short pixval = image_data[ci][row][input_cols - 1];
                    int count = numcols;
                    while (count > 0) {
                        image_data[ci][row][output_cols - count] = pixval;
                        --count;
                    }
                    ++row;
                }
                ci = (short)(ci + 1);
            }
        }
        if (input_rows < output_rows) {
            short ci = 0;
            while (ci < cinfo.num_components) {
                int row = input_rows;
                while (row < output_rows) {
                    int col = 0;
                    while (col < output_cols) {
                        image_data[ci][row][col] = image_data[ci][input_rows - 1][col];
                        ++col;
                    }
                    ++row;
                }
                ci = (short)(ci + 1);
            }
        }
    }
}

