/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class CameraPhoto {
    public Player player;
    private VideoControl videoControl;
    private byte[] image;
    public Image gambar;
    private DataOutputStream save;

    public CameraPhoto(MainCanvas parent) {
        try {
            this.player = Manager.createPlayer((String)"capture://image");
            this.player.realize();
            this.videoControl = (VideoControl)this.player.getControl("VideoControl");
            if (this.videoControl != null) {
                this.videoControl.initDisplayMode(1, (Object)parent);
            }
            this.videoControl.setDisplayLocation(0, 0);
            this.videoControl.setDisplaySize(320, 240);
            this.videoControl.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startCamera() {
        try {
            if (this.videoControl != null) {
                this.videoControl.setVisible(true);
            }
            if (this.player != null) {
                this.player.prefetch();
                this.player.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image getSnapshot() {
        try {
            this.image = this.videoControl.getSnapshot(null);
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        this.gambar = Image.createImage((byte[])this.image, (int)0, (int)this.image.length);
        return this.gambar;
    }

    public void savePhoto(byte[] gambar, String fileName) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)(String.valueOf(System.getProperty("fileconn.dir.photos")) + fileName + ".jpg"));
            if (fc.exists()) {
                fc.delete();
                fc.create();
                this.save = new DataOutputStream(fc.openDataOutputStream());
                ((OutputStream)this.save).write(gambar);
            } else {
                fc.create();
                this.save = new DataOutputStream(fc.openDataOutputStream());
                ((OutputStream)this.save).write(gambar);
            }
            this.save.close();
            fc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void savePhoto(Image iBaru, String fileName) {
        try {
            JPGEncoder encoder = new JPGEncoder();
            byte[] data = encoder.encode(iBaru, 90);
            this.savePhoto(data, fileName);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void stopCamera() {
        try {
            if (this.videoControl != null) {
                this.videoControl.setVisible(false);
            }
            if (this.player != null) {
                this.player.stop();
                this.player.deallocate();
                this.player.close();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }
}

