/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

final class BTImageClient
implements Runnable,
DiscoveryListener {
    private static final UUID PICTURES_SERVER_UUID = new UUID("4809b7908f9d11e29e960800200c9a66", false);
    private static final int IMAGES_NAMES_ATTRIBUTE_ID = 17185;
    private static final int READY = 0;
    private static final int DEVICE_SEARCH = 1;
    private static final int SERVICE_SEARCH = 2;
    private int state = 0;
    private DiscoveryAgent discoveryAgent;
    private MainCanvas parent;
    private boolean isClosed;
    private String petName;
    private int petLv;
    private String gameVersion;
    private int tipePet;
    private int petStr;
    private int petAgi;
    private int petDef;
    private int petIntel;
    private int petEnergy;
    private int petMaxHp;
    private static final int CONN_IDLE = 0;
    private static final int CONN_CONNECTING = 1;
    private static final int CONN_ACCEPTED = 2;
    private static final int CONN_REJECTED = 3;
    private int CONN_STATUS_CODE = 0;
    private Thread processorThread;
    private Vector devices = new Vector();
    private Vector records = new Vector();
    private int discType;
    private int[] searchIDs;
    private String serverName;
    private Hashtable base = new Hashtable();
    private boolean isDownloadCanceled;
    private UUID[] uuidSet;
    private int[] attrSet;
    private boolean blockOnce;
    private StreamConnection conn;

    BTImageClient(MainCanvas parent, String petName, int tipePet, int petLv, int petStr, int petDef, int petAgi, int petIntel, int petEnergy, int petMaxHp) {
        this.petName = petName;
        this.tipePet = tipePet;
        this.petLv = petLv;
        this.petStr = petStr;
        this.petDef = petDef;
        this.petAgi = petAgi;
        this.petIntel = petIntel;
        this.petEnergy = petEnergy;
        this.petMaxHp = petMaxHp;
        this.gameVersion = "3.0.0";
        this.parent = parent;
    }

    public void run() {
        boolean isBTReady = false;
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = localDevice.getDiscoveryAgent();
            isBTReady = true;
        }
        catch (Exception e2) {
            System.err.println("Can't initialize bluetooth: " + e2);
        }
        if (!isBTReady) {
            return;
        }
        this.uuidSet = new UUID[2];
        this.uuidSet[0] = new UUID(4353L);
        this.uuidSet[1] = PICTURES_SERVER_UUID;
        this.attrSet = new int[1];
        this.attrSet[0] = 17185;
        this.processTrainerSearch();
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (this.devices.indexOf(btDevice) == -1) {
            this.devices.addElement(btDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        this.discType = discType;
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.notify();
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        int i = 0;
        while (i < servRecord.length) {
            this.records.addElement(servRecord[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int transID, int respCode) {
        int index = -1;
        int i = 0;
        while (i < this.searchIDs.length) {
            if (this.searchIDs[i] == transID) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            System.err.println("Unexpected transaction index: " + transID);
        } else {
            this.searchIDs[index] = -1;
        }
        i = 0;
        while (i < this.searchIDs.length) {
            if (this.searchIDs[i] != -1) {
                return;
            }
            ++i;
        }
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestSearch() {
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.CONN_STATUS_CODE = 0;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelSearch() {
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            if (this.state == 1) {
                this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
            } else if (this.state == 2) {
                int i = 0;
                while (i < this.searchIDs.length) {
                    this.discoveryAgent.cancelServiceSearch(this.searchIDs[i]);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestLoad(String name) {
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.serverName = name;
            this.blockOnce = true;
            this.notify();
        }
    }

    void cancelLoad() {
        this.isDownloadCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        BTImageClient bTImageClient = this;
        synchronized (bTImageClient) {
            this.CONN_STATUS_CODE = 0;
            this.isClosed = true;
            this.isDownloadCanceled = true;
            this.notify();
        }
        try {
            this.processorThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void restartService() {
        this.isClosed = false;
        this.blockOnce = false;
        this.processorThread = new Thread(this);
        this.processorThread.start();
    }

    private synchronized void processTrainerSearch() {
        block4: while (!this.isClosed) {
            this.state = 0;
            if (this.blockOnce) {
                try {
                    this.wait();
                }
                catch (InterruptedException e2) {
                    System.err.println("Unexpected interruption: " + e2);
                    return;
                }
            }
            if (this.isClosed) {
                return;
            }
            if (!this.searchDevices()) {
                return;
            }
            if (this.devices.size() == 0) continue;
            if (!this.searchServices()) {
                return;
            }
            if (this.records.size() == 0 || !this.presentUserSearchResults()) continue;
            while (true) {
                this.isDownloadCanceled = false;
                try {
                    this.wait();
                }
                catch (InterruptedException e3) {
                    System.err.println("Unexpected interruption: " + e3);
                    return;
                }
                if (this.isClosed) {
                    return;
                }
                if (this.serverName == null) continue block4;
                String connResponse = this.challengeTrainer();
                if (this.isClosed) {
                    return;
                }
                if (this.isDownloadCanceled) continue;
                if (connResponse == null) {
                    this.parent.informSearchError(new String[]{"Your friend's dragon", "already go away."});
                    continue;
                }
                if (connResponse.compareTo("Accept") == 0) {
                    this.CONN_STATUS_CODE = 2;
                    this.parent.accBattle();
                    continue;
                }
                if (connResponse.compareTo("Reject") != 0) continue;
                this.CONN_STATUS_CODE = 3;
                this.parent.rejectBattle();
            }
        }
    }

    private boolean searchDevices() {
        this.state = 1;
        this.devices.removeAllElements();
        try {
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException e2) {
            System.err.println("Can't start inquiry now: " + (Object)((Object)e2));
            this.parent.informSearchError(new String[]{"Can't start device search"});
            return true;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e3) {
            System.err.println("Unexpected interruption: " + e3);
            return false;
        }
        if (this.isClosed) {
            return false;
        }
        switch (this.discType) {
            case 7: {
                this.parent.informSearchError(new String[]{"Device discovering error..."});
            }
            case 5: {
                this.devices.removeAllElements();
                break;
            }
            case 0: {
                if (this.devices.size() != 0) break;
                this.parent.informSearchError(new String[]{"No dragon around your area"});
                break;
            }
            default: {
                System.err.println("system error: unexpected device discovery code: " + this.discType);
                this.destroy();
                return false;
            }
        }
        return true;
    }

    private boolean searchServices() {
        this.state = 2;
        this.records.removeAllElements();
        this.searchIDs = new int[this.devices.size()];
        boolean isSearchStarted = false;
        int i = 0;
        while (i < this.devices.size()) {
            block8: {
                RemoteDevice rd = (RemoteDevice)this.devices.elementAt(i);
                System.out.println("Bluetooth addr : " + rd.getBluetoothAddress());
                System.out.println(rd.toString());
                try {
                    this.searchIDs[i] = this.discoveryAgent.searchServices(this.attrSet, this.uuidSet, rd, (DiscoveryListener)this);
                }
                catch (BluetoothStateException e2) {
                    System.err.println("Can't search services for: " + rd.getBluetoothAddress() + " due to " + (Object)((Object)e2));
                    this.searchIDs[i] = -1;
                    break block8;
                }
                isSearchStarted = true;
            }
            ++i;
        }
        if (!isSearchStarted) {
            this.parent.informSearchError(new String[]{"Can't search services."});
            return true;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e3) {
            System.err.println("Unexpected interruption: " + e3);
            return false;
        }
        if (this.isClosed) {
            return false;
        }
        if (this.records.size() == 0) {
            this.parent.informSearchError(new String[]{"No dragon around your area"});
        }
        return true;
    }

    private boolean presentUserSearchResults() {
        this.base.clear();
        int i = 0;
        while (i < this.records.size()) {
            ServiceRecord sr = (ServiceRecord)this.records.elementAt(i);
            DataElement de = sr.getAttributeValue(17185);
            if (de == null) {
                System.err.println("Unexpected service - missed attribute");
            } else {
                Enumeration deEnum = (Enumeration)de.getValue();
                while (deEnum.hasMoreElements()) {
                    de = (DataElement)deEnum.nextElement();
                    String name = (String)de.getValue();
                    Object obj = this.base.get(name);
                    if (obj != null) {
                        Vector<Object> v;
                        if (obj instanceof ServiceRecord) {
                            v = new Vector<Object>();
                            v.addElement(obj);
                        } else {
                            v = (Vector<Object>)obj;
                        }
                        v.addElement(sr);
                        obj = v;
                    } else {
                        obj = sr;
                    }
                    this.base.put(name, obj);
                }
            }
            ++i;
        }
        return this.parent.showImagesNames(this.base);
    }

    public int getConnStatus() {
        return this.CONN_STATUS_CODE;
    }

    private String challengeTrainer() {
        System.out.println("testTrainer");
        if (this.serverName == null) {
            System.err.println("Error: serverName=null");
            return null;
        }
        this.CONN_STATUS_CODE = 1;
        ServiceRecord[] sr = null;
        Object obj = this.base.get(this.serverName);
        if (obj == null) {
            System.err.println("Error: no record for: " + this.serverName);
            return null;
        }
        if (obj instanceof ServiceRecord) {
            sr = new ServiceRecord[]{(ServiceRecord)obj};
        } else {
            Vector v = (Vector)obj;
            sr = new ServiceRecord[v.size()];
            int i = 0;
            while (i < v.size()) {
                sr[i] = (ServiceRecord)v.elementAt(i);
                ++i;
            }
        }
        int i = 0;
        while (i < sr.length) {
            block11: {
                this.conn = null;
                String url = null;
                if (this.isDownloadCanceled) {
                    return null;
                }
                try {
                    url = sr[i].getConnectionURL(0, false);
                    System.out.println("Service URL: " + url);
                    this.conn = (StreamConnection)Connector.open((String)url);
                }
                catch (IOException e2) {
                    System.err.println("Note: can't connect to: " + url);
                    break block11;
                }
                String challengerInfo = String.valueOf(this.petName) + "|" + this.tipePet + "|" + this.petLv + "|" + this.petStr + "|" + this.petDef + "|" + this.petAgi + "|" + this.petIntel + "|" + this.petEnergy + "|" + this.petMaxHp + "|" + this.gameVersion;
                this.sendMessage(challengerInfo);
                byte[] responseData = this.readMessage();
                String responseString = "";
                try {
                    responseString = new String(responseData);
                    System.out.println("Response String : " + responseString);
                }
                catch (Exception e3) {
                    System.err.println("Error: wrong image data from: " + url);
                    break block11;
                }
                return responseString;
            }
            ++i;
        }
        return null;
    }

    public void sendMessage(String x) {
        try {
            OutputStream out = this.conn.openOutputStream();
            out.write(x.length());
            out.write(x.getBytes());
            out.flush();
            out.close();
        }
        catch (Exception E) {
            System.out.println("Error gagal kirim pesan " + x);
        }
    }

    public byte[] readMessage() {
        byte[] responseData = null;
        try {
            InputStream in = this.conn.openInputStream();
            int length = in.read() << 8;
            if ((length |= in.read()) <= 0) {
                throw new IOException("Can't read a length");
            }
            responseData = new byte[length];
            length = 0;
            while (length != responseData.length) {
                int n = in.read(responseData, length, responseData.length - length);
                if (n == -1) {
                    throw new IOException("Can't read a image data");
                }
                length += n;
            }
            in.close();
        }
        catch (IOException e2) {
            System.err.println("Can't read from server");
        }
        return responseData;
    }

    public void closeCon() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

