/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.DataElement;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

final class BTImageServer
implements Runnable {
    private static final UUID PICTURES_SERVER_UUID = new UUID("4809b7908f9d11e29e960800200c9a66", false);
    private static final int IMAGES_NAMES_ATTRIBUTE_ID = 17185;
    private LocalDevice localDevice;
    private StreamConnectionNotifier notifier;
    private ServiceRecord record;
    private MainCanvas parent;
    private boolean isClosed;
    private int isConfirming;
    private String petName;
    private Thread accepterThread;
    private ClientProcessor processor;
    private final Hashtable dataElements = new Hashtable();
    private StreamConnection conn;

    BTImageServer(MainCanvas parent, String petName) {
        this.parent = parent;
        this.petName = petName;
        this.isConfirming = 0;
    }

    public void restartService() {
        this.accepterThread = new Thread(this);
        this.accepterThread.start();
    }

    public void run() {
        boolean isBTReady = false;
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            this.localDevice.setDiscoverable(10390323);
            StringBuffer url = new StringBuffer("btspp://");
            url.append("localhost").append(':');
            url.append(PICTURES_SERVER_UUID.toString());
            url.append(";name=OwnPetDragon");
            url.append(";authorize=false");
            this.notifier = (StreamConnectionNotifier)Connector.open((String)url.toString());
            this.record = this.localDevice.getRecord((Connection)this.notifier);
            DataElement base = new DataElement(48);
            this.record.setAttributeValue(17185, base);
            int[] iDs = this.record.getAttributeIDs();
            int k = 0;
            while (k < iDs.length) {
                System.out.println("ID | VAL : " + iDs[k] + " | " + this.record.getAttributeValue(iDs[k]) + " | " + base.toString());
                ++k;
            }
            isBTReady = true;
            this.changeImageInfo(this.petName, true);
        }
        catch (Exception e2) {
            System.err.println("Can't initialize bluetooth: " + e2);
        }
        if (!isBTReady) {
            return;
        }
        this.processor = new ClientProcessor();
        while (!this.isClosed) {
            if (this.isConfirming != 0) continue;
            this.conn = null;
            try {
                this.conn = this.notifier.acceptAndOpen();
                this.isConfirming = 1;
                String challengerInfo = this.readChallengerInfo();
                System.out.println("challenger info : " + challengerInfo);
                this.parent.displayDuelConfirmation(challengerInfo);
                this.changeImageInfo(this.petName, false);
            }
            catch (IOException e3) {
                e3.printStackTrace();
                this.isConfirming = 0;
                System.out.println("testasd");
                continue;
            }
            this.processor.addConnection();
        }
    }

    void acceptDuel() {
        this.isConfirming = 2;
    }

    void rejectDuel() {
        this.isConfirming = 3;
    }

    void setConfirming(int value) {
        this.isConfirming = value;
    }

    boolean changeImageInfo(String name, boolean isPublished) {
        DataElement base = this.record.getAttributeValue(17185);
        DataElement de = (DataElement)this.dataElements.get(name);
        if (de == null) {
            System.out.println(String.valueOf(name) + " --- ");
            de = new DataElement(32, (Object)name);
            this.dataElements.put(name, de);
        }
        if (isPublished) {
            base.addElement(de);
        } else if (!base.removeElement(de)) {
            System.err.println("Error: item was not removed for: " + name);
            return false;
        }
        this.record.setAttributeValue(17185, base);
        try {
            this.localDevice.updateRecord(this.record);
        }
        catch (ServiceRegistrationException e2) {
            System.err.println("Can't update record now for: " + name);
            return false;
        }
        return true;
    }

    void destroy() {
        this.isClosed = true;
        if (this.notifier != null) {
            try {
                this.notifier.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.accepterThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.processor != null) {
            this.processor.destroy(true);
        }
        this.processor = null;
    }

    private void processConnection() {
        if (this.isConfirming == 2) {
            byte[] imgData = "Accept".getBytes();
            this.sendImageData(imgData);
            this.isConfirming = 4;
        } else if (this.isConfirming == 3) {
            byte[] imgData = "Reject".getBytes();
            this.sendImageData(imgData);
            this.isConfirming = 5;
        } else if (this.isConfirming == 4 && this.readChallengerInfo().compareTo("Ayo") == 0) {
            this.isConfirming = 6;
        }
    }

    public void closeConn() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendImageData(byte[] imgData) {
        if (imgData == null) {
            return;
        }
        OutputStream out = null;
        try {
            out = this.conn.openOutputStream();
            out.write(imgData.length >> 8);
            out.write(imgData.length & 0xFF);
            out.write(imgData);
            out.flush();
        }
        catch (IOException e2) {
            System.err.println("Can't send image data: " + e2);
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String readChallengerInfo() {
        String challengerInfo = null;
        InputStream in = null;
        try {
            in = this.conn.openInputStream();
            int length = in.read();
            if (length <= 0) {
                throw new IOException("Can't read name length");
            }
            byte[] nameData = new byte[length];
            length = 0;
            while (length != nameData.length) {
                int n = in.read(nameData, length, nameData.length - length);
                if (n == -1) {
                    throw new IOException("Can't read name data");
                }
                length += n;
            }
            challengerInfo = new String(nameData);
        }
        catch (IOException e2) {
            System.err.println(e2);
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return challengerInfo;
    }

    private class ClientProcessor
    implements Runnable {
        private Thread processorThread;
        private Vector queue = new Vector();

        ClientProcessor() {
            this.processorThread = new Thread(this);
            this.processorThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!BTImageServer.this.isClosed) {
                ClientProcessor clientProcessor = this;
                synchronized (clientProcessor) {
                    if (this.queue.size() == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e2) {
                            System.err.println("Unexpected exception: " + e2);
                            this.destroy(false);
                            return;
                        }
                    }
                }
                clientProcessor = this;
                synchronized (clientProcessor) {
                    if (BTImageServer.this.isClosed) {
                        return;
                    }
                    BTImageServer.this.conn = (StreamConnection)this.queue.firstElement();
                    if (BTImageServer.this.isConfirming > 1 && BTImageServer.this.isConfirming < 5) {
                        BTImageServer.this.processConnection();
                    } else if (BTImageServer.this.isConfirming == 5) {
                        this.queue.removeElementAt(0);
                        BTImageServer.this.isConfirming = 0;
                    } else if (BTImageServer.this.isConfirming == 6) {
                        this.queue.removeElementAt(0);
                        BTImageServer.this.isConfirming = 0;
                        BTImageServer.this.parent.battle();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addConnection() {
            ClientProcessor clientProcessor = this;
            synchronized (clientProcessor) {
                this.queue.addElement(BTImageServer.this.conn);
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void destroy(boolean needJoin) {
            ClientProcessor clientProcessor = this;
            synchronized (clientProcessor) {
                this.notify();
                while (this.queue.size() != 0) {
                    StreamConnection conn = (StreamConnection)this.queue.firstElement();
                    this.queue.removeElementAt(0);
                    try {
                        conn.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            try {
                this.processorThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

