/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public class Write {
    static final short NUM_QUANT_TBLS = 4;
    static final short DCTSIZE = 8;
    static final short NUM_ARITH_TBLS = 4;
    public static final byte SOF0 = -64;
    public static final byte SOF1 = -63;
    public static final byte SOF2 = -62;
    public static final byte SOF3 = -61;
    public static final byte SOF5 = -59;
    public static final byte SOF6 = -58;
    public static final byte SOF7 = -57;
    public static final byte JPG = -56;
    public static final byte SOF9 = -55;
    public static final byte SOF10 = -54;
    public static final byte SOF11 = -53;
    public static final byte SOF13 = -51;
    public static final byte SOF14 = -50;
    public static final byte SOF15 = -49;
    public static final byte DHT = -60;
    public static final byte DAC = -52;
    public static final byte RST0 = -48;
    public static final byte RST1 = -47;
    public static final byte RST2 = -46;
    public static final byte RST3 = -45;
    public static final byte RST4 = -44;
    public static final byte RST5 = -43;
    public static final byte RST6 = -42;
    public static final byte RST7 = -41;
    public static final byte SOI = -40;
    public static final byte EOI = -39;
    public static final byte SOS = -38;
    public static final byte DQT = -37;
    public static final byte DNL = -36;
    public static final byte DRI = -35;
    public static final byte DHP = -34;
    public static final byte EXP = -33;
    public static final byte APP0 = -32;
    public static final byte APP15 = -17;
    public static final byte JPG0 = -16;
    public static final byte JPG13 = -3;
    public static final byte COM = -2;
    public static final byte TEM = 1;
    public static final byte ERROR = 0;

    static void write_byte(CompressInfo cinfo, int b2) {
        try {
            cinfo.output_file.writeByte(b2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void write_bytes(CompressInfo cinfo, byte[] data, int count) {
        try {
            cinfo.output_file.write(data, 0, count);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void write_marker(CompressInfo cinfo, byte mark) {
        Write.write_byte(cinfo, 255);
        Write.write_byte(cinfo, mark);
    }

    static void write_2bytes(CompressInfo cinfo, int value) {
        Write.write_byte(cinfo, value >> 8 & 0xFF);
        Write.write_byte(cinfo, value & 0xFF);
    }

    static void write_dqt(CompressInfo cinfo, int index) {
        Write.write_marker(cinfo, (byte)-37);
        Write.write_2bytes(cinfo, 67);
        Write.write_byte(cinfo, index);
        int i = 0;
        while (i < 64) {
            Write.write_byte(cinfo, cinfo.quant_tbl[index][i]);
            ++i;
        }
    }

    static void write_dht(CompressInfo cinfo, int index, boolean is_ac) {
        HuffTbl htbl;
        if (is_ac) {
            htbl = cinfo.ac_huff_tbl[index];
            index += 16;
        } else {
            htbl = cinfo.dc_huff_tbl[index];
        }
        if (htbl == null) {
            util.errexit("Huffman table " + index + " was not defined");
        }
        if (!htbl.sent_table) {
            Write.write_marker(cinfo, (byte)-60);
            int length = 0;
            int i = 1;
            while (i <= 16) {
                length += htbl.bits[i];
                ++i;
            }
            Write.write_2bytes(cinfo, length + 2 + 1 + 16);
            Write.write_byte(cinfo, index);
            i = 1;
            while (i <= 16) {
                Write.write_byte(cinfo, htbl.bits[i]);
                ++i;
            }
            i = 0;
            while (i < length) {
                Write.write_byte(cinfo, htbl.huffval[i]);
                ++i;
            }
            htbl.sent_table = true;
        }
    }

    static void write_sof(CompressInfo cinfo, byte code) {
        Write.write_marker(cinfo, code);
        Write.write_2bytes(cinfo, 3 * cinfo.num_components + 2 + 5 + 1);
        Write.write_byte(cinfo, cinfo.data_precision);
        Write.write_2bytes(cinfo, cinfo.image_height);
        Write.write_2bytes(cinfo, cinfo.image_width);
        Write.write_byte(cinfo, cinfo.num_components);
        int i = 0;
        while (i < cinfo.num_components) {
            Write.write_byte(cinfo, cinfo.comp_info[i].component_id);
            Write.write_byte(cinfo, (cinfo.comp_info[i].h_samp_factor << 4) + cinfo.comp_info[i].v_samp_factor);
            Write.write_byte(cinfo, cinfo.comp_info[i].quant_tbl_no);
            ++i;
        }
    }

    static void write_sos(CompressInfo cinfo) {
        Write.write_marker(cinfo, (byte)-38);
        Write.write_2bytes(cinfo, 2 * cinfo.comps_in_scan + 2 + 1 + 3);
        Write.write_byte(cinfo, cinfo.comps_in_scan);
        int i = 0;
        while (i < cinfo.comps_in_scan) {
            Write.write_byte(cinfo, cinfo.cur_comp_info[i].component_id);
            Write.write_byte(cinfo, (cinfo.cur_comp_info[i].dc_tbl_no << 4) + cinfo.cur_comp_info[i].ac_tbl_no);
            ++i;
        }
        Write.write_byte(cinfo, 0);
        Write.write_byte(cinfo, 63);
        Write.write_byte(cinfo, 0);
    }

    public static void write_file_header(CompressInfo cinfo) {
        short[] qt_in_use = new short[4];
        Write.write_marker(cinfo, (byte)-40);
        int i = 0;
        while (i < 4) {
            qt_in_use[i] = 0;
            ++i;
        }
        i = 0;
        while (i < cinfo.num_components) {
            qt_in_use[cinfo.comp_info[i].quant_tbl_no] = 1;
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (qt_in_use[i] != 0) {
                Write.write_dqt(cinfo, i);
            }
            ++i;
        }
        boolean is_baseline = true;
        if (is_baseline) {
            Write.write_sof(cinfo, (byte)-64);
        } else {
            Write.write_sof(cinfo, (byte)-63);
        }
    }

    public static void write_scan_header(CompressInfo cinfo) {
        int i = 0;
        while (i < cinfo.comps_in_scan) {
            Write.write_dht(cinfo, cinfo.cur_comp_info[i].dc_tbl_no, false);
            Write.write_dht(cinfo, cinfo.cur_comp_info[i].ac_tbl_no, true);
            ++i;
        }
        Write.write_sos(cinfo);
    }

    public static void write_jpeg_data(CompressInfo cinfo, byte[] data, int datacount) {
        Write.write_bytes(cinfo, data, datacount);
    }

    public static void write_file_trailer(CompressInfo cinfo) {
        Write.write_marker(cinfo, (byte)-39);
        try {
            cinfo.output_file.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

