/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

public class JPGEncoder {
    private int state;
    CompressInfo cinfo;
    OutputStream out;
    Image image;
    short[][][] sample_buf;
    short[][][] sampled_img = null;
    int fullwidth;
    int rows_in_mcu;
    int rows_to_get;
    int cur_pixel_row;
    int ci;
    public static final short CS_UNKNOWN = 0;
    public static final short CS_GRAYSCALE = 1;
    public static final short CS_RGB = 2;
    public static final short CS_YCbCr = 3;
    static final short DCTSIZE = 8;
    static final int DEFAULT_QUALITY = 75;
    int quality_ = 75;
    public Shared shared = new Shared();

    void input_init(CompressInfo cinfo) {
        cinfo.in_color_space = (short)-1;
        if (cinfo.in_color_space == -1) {
            cinfo.input_components = (short)3;
            cinfo.in_color_space = (short)2;
        }
        cinfo.image_width = cinfo.ji.getWidth();
        cinfo.image_height = cinfo.ji.getHeight();
    }

    public void encode(OutputStream out, Image ji, int quality) {
        try {
            this.initSpecificEncoder(out, ji, quality);
            this.driveEncoder();
            this.freeEncoder();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public byte[] encode(Image ji, int quality) {
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream();
            this.initSpecificEncoder(output, ji, quality);
            this.driveEncoder();
            this.freeEncoder();
            return output.toByteArray();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public void initSpecificEncoder(OutputStream out, Image ji, int quality) {
        this.out = out;
        this.state = 0;
        this.image = ji;
        this.quality_ = quality;
    }

    void initCInfo() throws Exception {
        this.cinfo = new CompressInfo(this.quality_);
        this.cinfo.output_file = new DataOutputStream(this.out);
        this.cinfo.ji = this.image;
        this.input_init(this.cinfo);
        CompressSetup.setCDefaults(this.cinfo);
        if (this.cinfo.in_color_space == 1) {
            CompressSetup.setMDefaults(this.cinfo);
        }
        CompressSetup.initial_setup(this.cinfo);
        if (this.cinfo.interleave) {
            CompressSetup.interleaved_scan_setup(this.cinfo);
        } else {
            CompressSetup.noninterleaved_scan_setup(this.cinfo);
        }
        this.fullwidth = util.roundUp(this.cinfo.image_width, this.cinfo.max_h_samp_factor * 8);
        this.rows_in_mcu = this.cinfo.max_v_samp_factor * 8;
        this.sample_buf = new short[this.cinfo.num_components][this.rows_in_mcu][this.fullwidth];
        this.sampled_img = new short[this.cinfo.num_components][this.rows_in_mcu][this.fullwidth];
        this.shared.convertColor.rgb_ycc_init(this.cinfo);
        this.shared.huffEncode.huff_init(this.cinfo);
    }

    public boolean driveEncoder() throws Exception {
        this.initCInfo();
        Write.write_file_header(this.cinfo);
        Write.write_scan_header(this.cinfo);
        this.cur_pixel_row = 0;
        while (this.cur_pixel_row < this.cinfo.image_height) {
            this.rows_to_get = Math.min(this.rows_in_mcu, this.cinfo.image_height - this.cur_pixel_row);
            if (this.cinfo.num_components == 1) {
                this.shared.convertColor.get_grayscale_rows(this.cinfo, this.rows_to_get, this.sample_buf);
            } else if (this.cinfo.num_components == 3) {
                this.shared.convertColor.get_rgb_ycc_rows(this.cinfo, this.rows_to_get, this.sample_buf);
            }
            Sample.edge_expand(this.cinfo, this.cinfo.image_width, this.rows_to_get, this.fullwidth, this.rows_in_mcu, this.sample_buf);
            this.ci = 0;
            while (this.ci < this.cinfo.num_components) {
                Sample.downsample(this.cinfo, this.ci, this.cinfo.comp_info[this.ci].true_comp_width, this.cinfo.comp_info[this.ci].v_samp_factor * 8, this.sample_buf[this.ci], this.sampled_img[this.ci]);
                ++this.ci;
            }
            this.shared.mcu.extract_MCUs(this.cinfo, this.sampled_img, 1);
            this.cur_pixel_row += this.rows_in_mcu;
        }
        this.shared.huffEncode.huff_term(this.cinfo);
        Write.write_file_trailer(this.cinfo);
        return false;
    }

    public void freeEncoder() throws Exception {
        this.sample_buf = null;
        this.sampled_img = null;
        this.cinfo.ji = null;
        this.cinfo = null;
    }

    public int getState() {
        return this.state;
    }
}

