/*
 * Decompiled with CFR 0.152.
 */
public class NagaCave {
    public int vx;
    public int vy;
    public int state;
    public int x;
    public int y;
    public int distance;
    public int width;
    public int height;
    public int coin;
    public int life;
    public boolean drawUp;
    public int regen;

    public NagaCave(int width, int height) {
        this.width = width;
        this.height = height;
        this.x = -width;
        this.y = 120 - height / 2;
        this.vx = 10;
        this.vy = this.vx / 2;
        this.life = 1;
        this.state = -1;
        this.distance = 0;
        this.coin = 0;
        this.drawUp = true;
        this.regen = 0;
    }

    public void ready() {
        this.state = 0;
    }

    public void die() {
        this.state = -3;
    }

    public void act() {
        switch (this.state) {
            case -3: {
                this.x -= this.vx;
                if (this.x > -this.width) break;
                this.state = -2;
                break;
            }
            case -2: {
                break;
            }
            case -1: {
                if (this.x == 20) {
                    this.state = -2;
                    break;
                }
                this.x += this.vx;
                if (this.x <= 20) break;
                this.x = 20;
                break;
            }
            case 0: {
                if (this.vx < 20) {
                    this.vx = this.distance / 500 + 10;
                    if (this.vx > 20) {
                        this.vx = 20;
                    }
                }
                this.vy = this.vx * 3 / 2;
                if (this.y < 120 - this.height / 2) {
                    this.y += this.vy;
                    if (this.y > 120 - this.height / 2) {
                        this.y = 120 - this.height / 2;
                    }
                } else if (this.y > 120 - this.height / 2) {
                    this.y -= this.vy;
                    if (this.y < 120 - this.height / 2) {
                        this.y = 120 - this.height / 2;
                    }
                }
                if (this.life > 0) break;
                this.die();
                break;
            }
            case 1: {
                this.state = 0;
            }
        }
        if (this.regen > 0) {
            --this.regen;
        }
        if (this.state >= 0) {
            this.distance += this.vx / 2;
        }
    }

    public void moveUp() {
        if (this.state == 0 || this.state == 1) {
            this.y -= this.vy;
            if (this.y < 35) {
                this.y = 35;
            }
            this.drawUp = true;
            this.state = 1;
        }
    }

    public void moveDown() {
        if (this.state == 0 || this.state == 1) {
            this.y += this.vy;
            if (this.y > 205 - this.height) {
                this.y = 205 - this.height;
            }
            this.drawUp = false;
            this.state = 1;
        }
    }
}

