/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.airport.views;

import com.rocktasticgames.airport.main.MainActivity;
import com.rocktasticgames.airport.utils.MotionEvent;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashRocktasticView {
    private MainActivity activity;
    private Image bmp;
    private boolean drawn = false;
    private boolean exec = false;
    private long start_time;

    public SplashRocktasticView(MainActivity mainActivity) {
        this.activity = mainActivity;
        try {
            this.bmp = Image.createImage((String)"/logo_rocktastic.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        this.bmp = null;
        System.gc();
    }

    public void onDraw(Graphics graphics) {
        if (this.drawn && !this.exec) {
            this.activity.splashTaskTwo();
            this.exec = true;
        }
        graphics.setColor(-1);
        graphics.fillRect(0, 0, this.activity.getCanvas().getWidth(), this.activity.getCanvas().getHeight());
        graphics.drawImage(this.bmp, this.activity.getCanvas().getWidth() / 2, this.activity.getCanvas().getHeight() / 2, 3);
        if (!this.drawn) {
            this.drawn = true;
            this.start_time = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() > this.start_time + 2000L) {
            this.activity.onSplashTwoComplete();
        } else if (this.exec) {
            this.activity.postInvalidateDelayed(500L);
        } else {
            this.activity.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        this.activity.invalidate();
        switch (n) {
            case 1: {
                if (this.drawn && this.exec) {
                    this.activity.onSplashTwoComplete();
                }
                return false;
            }
        }
        return true;
    }
}

