/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.platform.DictionaryKeyValue;
import com.renderedideas.platform.PlatformService;
import com.renderedideas.platform.Sound;
import com.renderedideas.yourgamename.Constants;
import com.renderedideas.yourgamename.Game;

public class SoundManager {
    public static DictionaryKeyValue sounds;

    public static void loadSounds() {
        sounds = new DictionaryKeyValue();
        if (!PlatformService.isSoundMixingSupported()) {
            return;
        }
        try {
            SoundManager.add(Constants.SOUND_ARROW_HIT, 100, "audio/arrowHit.wav", 1);
            SoundManager.add(Constants.SOUND_ARROW_RELEASE, 100, "audio/arrowRelease.wav", 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void add(Object id, int soundVolume, String filePath, int loopCount) throws Exception {
        if (sounds == null) {
            sounds = new DictionaryKeyValue();
        } else if (sounds.containsKey(id)) {
            return;
        }
        sounds.put(id, new Sound(soundVolume, filePath, loopCount));
    }

    public static void remove(Object id) {
        if (sounds == null) {
            return;
        }
        Sound sound = (Sound)sounds.remove(id);
        if (sound != null) {
            sound.unload();
            sound = null;
        }
    }

    public static void play(Object id) {
        if (!Game.volumeFlag) {
            return;
        }
        if (sounds == null) {
            return;
        }
        Sound sound = (Sound)sounds.get(id);
        if (sound != null) {
            sound.play();
        }
    }

    public static void stop(Object id) {
        if (sounds == null) {
            return;
        }
        Sound sound = (Sound)sounds.get(id);
        if (sound != null) {
            sound.stop();
        }
    }

    public static void stopAll() {
        if (sounds == null) {
            return;
        }
        Object[] objects = sounds.getAllValues();
        for (int i = 0; i < objects.length; ++i) {
            Sound s = (Sound)objects[i];
            s.stop();
        }
    }

    public static void removeAll() {
        if (sounds == null) {
            return;
        }
        Object[] objects = sounds.getAllValues();
        for (int i = 0; i < objects.length; ++i) {
            Sound s = (Sound)objects[i];
            s.unload();
            Object var2_2 = null;
        }
        sounds.clear();
        sounds = null;
    }

    public static boolean isPlaying(Object id) {
        if (sounds == null) {
            return false;
        }
        Sound sound = (Sound)sounds.get(id);
        if (sound != null) {
            return sound.isPlaying();
        }
        return false;
    }

    public static boolean isStopped(Object id) {
        if (sounds == null) {
            return false;
        }
        Sound sound = (Sound)sounds.get(id);
        if (sound != null) {
            return sound.isStopped();
        }
        return false;
    }

    public static boolean isPaused(Object id) {
        if (sounds == null) {
            return false;
        }
        Sound sound = (Sound)sounds.get(id);
        if (sound != null) {
            return sound.isPaused();
        }
        return false;
    }
}

