/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.platform.Bitmap;
import javax.microedition.lcdui.Graphics;

public class GameBackground {
    public int imageWidth;
    public int imageHeight;
    public int backgroundStart;
    public Bitmap backgroundBitmap;
    public String bitmapPath;

    public GameBackground(String bitmapSource) {
        this.bitmapPath = bitmapSource;
        this.backgroundBitmap = new Bitmap(bitmapSource);
        this.imageWidth = this.backgroundBitmap.getWidth();
        this.imageHeight = this.backgroundBitmap.getHeight();
        this.backgroundStart = 0;
    }

    public void update(int scrollSpeed) {
        this.backgroundStart += scrollSpeed;
    }

    public void paint(Graphics g2) {
        if (this.backgroundStart >= this.imageWidth) {
            this.backgroundStart = 0;
            Bitmap.drawBitmap(g2, this.backgroundBitmap, this.backgroundStart, 0);
        } else if (this.imageWidth - this.backgroundStart < GameManager.screenWidth) {
            Bitmap.drawBitmap(g2, this.backgroundBitmap, -this.backgroundStart, 0);
            Bitmap.drawBitmap(g2, this.backgroundBitmap, this.imageWidth - this.backgroundStart, 0);
        } else {
            Bitmap.drawBitmap(g2, this.backgroundBitmap, -this.backgroundStart, 0);
        }
    }
}

