/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.gamemanager;

import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.gamemanager.TileSpriteInfo;
import com.renderedideas.platform.Debug;
import com.renderedideas.platform.LoadResources;
import javax.microedition.lcdui.Graphics;

public class TileMap {
    public int startX;
    public int startY;
    public int maxX;
    public int maxY;
    public int MAX_PIXELS_Y;
    public int MAX_PIXELS_X;
    public byte[][][] tile;
    public boolean[][][] drawn;
    public int MAX_MAP_TILES_Y;
    public int MAX_MAP_TILES_X;
    public int TILE_WIDTH;
    public int TILE_HEIGHT;

    public TileMap(String filePath, int tileWidth, int tileHeight) {
        this.TILE_WIDTH = tileWidth;
        this.TILE_HEIGHT = tileHeight;
        this.LoadMap(filePath);
    }

    private void LoadMap(String filePath) {
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        String mapString = LoadResources.loadFileAsString(filePath);
        try {
            int startIndex = mapString.indexOf("width=") + 6;
            int endIndex = mapString.indexOf("\n", startIndex) - 1;
            this.MAX_MAP_TILES_X = Integer.parseInt(mapString.substring(startIndex, endIndex));
            startIndex = mapString.indexOf("height=") + 7;
            endIndex = mapString.indexOf("\n", startIndex) - 1;
            this.MAX_MAP_TILES_Y = Integer.parseInt(mapString.substring(startIndex, endIndex));
            this.MAX_PIXELS_Y = this.MAX_MAP_TILES_Y * this.TILE_HEIGHT;
            this.MAX_PIXELS_X = this.MAX_MAP_TILES_X * this.TILE_WIDTH;
            int layerCount = 0;
            startIndex = -1;
            while ((startIndex = mapString.indexOf("[layer]", startIndex + 1)) != -1) {
                ++layerCount;
            }
            this.tile = new byte[layerCount][this.MAX_MAP_TILES_Y][this.MAX_MAP_TILES_X];
            this.drawn = new boolean[layerCount][this.MAX_MAP_TILES_Y][this.MAX_MAP_TILES_X];
            startIndex = 0;
            for (int l = 0; l < layerCount; ++l) {
                startIndex = mapString.indexOf("data=", startIndex) + 5;
                startIndex += 2;
                for (int y = 0; y < this.MAX_MAP_TILES_Y; ++y) {
                    for (int x = 0; x < this.MAX_MAP_TILES_X; ++x) {
                        endIndex = mapString.indexOf(",", startIndex);
                        if (endIndex == -1 || endIndex - startIndex > 9) {
                            endIndex = mapString.indexOf("\n", startIndex) - 1;
                        }
                        this.tile[l][y][x] = Byte.parseByte(mapString.substring(startIndex, endIndex).trim());
                        this.drawn[l][y][x] = false;
                        startIndex = endIndex + 1;
                    }
                }
            }
        }
        catch (Exception e2) {
            Debug.print("Exception Reading TileMap:" + e2);
            e2.printStackTrace();
        }
        this.startX = 0;
        this.startY = 0;
        this.maxX = this.MAX_MAP_TILES_X * this.TILE_WIDTH;
        this.maxY = this.MAX_MAP_TILES_Y * this.TILE_HEIGHT;
    }

    public void MoveMap(int ScrollSpeed) {
        this.startX += ScrollSpeed;
    }

    public void DrawMap(Graphics g2, int ScreenWidth, int ScreenHeight, int layerIndex) {
        int x1;
        int mapX = this.startX / this.TILE_WIDTH;
        int x2 = x1 + ScreenWidth + ((x1 = this.startX % this.TILE_WIDTH * -1) == 0 ? 0 : this.TILE_WIDTH);
        int mapY = this.startY / this.TILE_HEIGHT;
        int y1 = this.startY % this.TILE_HEIGHT * -1;
        int y2 = y1 + ScreenHeight + (y1 == 0 ? 0 : this.TILE_HEIGHT);
        for (int y = y1; y < y2; y += this.TILE_HEIGHT) {
            mapX = this.startX / this.TILE_WIDTH;
            for (int x = x1; x < x2; x += this.TILE_WIDTH) {
                if (this.drawn[layerIndex][mapY][mapX]) {
                    ++mapX;
                    continue;
                }
                if (this.tile[layerIndex][mapY][mapX] == 1) {
                    // empty if block
                }
                ++mapX;
            }
            ++mapY;
        }
    }

    public Point getRequestedTile(int ID, int layerIndex) {
        int x1 = 0;
        int x2 = this.MAX_PIXELS_X;
        int mapY = 0;
        int y1 = 0;
        int y2 = this.MAX_PIXELS_Y;
        for (int y = y1; y < y2; y += this.TILE_HEIGHT) {
            int mapX = 0;
            for (int x = x1; x < x2; x += this.TILE_WIDTH) {
                if (this.tile[layerIndex][mapY][mapX] == ID) {
                    return new Point(x, y);
                }
                ++mapX;
            }
            ++mapY;
        }
        return null;
    }

    public TileSpriteInfo getTile(Point[] pointsToCheck, int layerIndex) {
        for (int i = 0; i < pointsToCheck.length; ++i) {
            TileSpriteInfo tileInfo = this.getTile((int)pointsToCheck[i].X, (int)pointsToCheck[i].Y, layerIndex);
            if (tileInfo == null) continue;
            return tileInfo;
        }
        return null;
    }

    public TileSpriteInfo getTile(int x, int y, int layerIndex) {
        if (y < 0) {
            return null;
        }
        if (y >= this.TILE_HEIGHT * this.MAX_MAP_TILES_Y) {
            return null;
        }
        if (x < 0) {
            return null;
        }
        if (x >= GameManager.screenWidth) {
            return null;
        }
        if (this.tile[layerIndex][(y = this.startY + y) / this.TILE_HEIGHT][(x = this.startX + x) / this.TILE_HEIGHT] >= 1) {
            TileSpriteInfo r = new TileSpriteInfo();
            r.tileID = this.tile[layerIndex][y / this.TILE_HEIGHT][x / this.TILE_WIDTH];
            r.position.X = x / this.TILE_WIDTH * this.TILE_WIDTH - this.startX;
            r.position.Y = y / this.TILE_HEIGHT * this.TILE_HEIGHT - this.startY;
            return r;
        }
        return null;
    }

    public void deallocate() {
        this.drawn = null;
        this.tile = null;
    }
}

