/*
 * Decompiled with CFR 0.152.
 */
package at.emini.physics2D;

import at.emini.physics2D.Body;
import at.emini.physics2D.Constraint;
import at.emini.physics2D.UserData;
import at.emini.physics2D.util.FXVector;
import at.emini.physics2D.util.PhysicsFileReader;
import java.util.Vector;

public class Spring
implements Constraint {
    private Body a;
    private Body b;
    private FXVector c;
    private FXVector d;
    private float e;
    protected float mCoefficientFX = 0.0f;
    protected UserData mUserData = null;
    private float f;
    private float g;
    private FXVector h = new FXVector();
    private float i;
    private FXVector j = new FXVector();
    private FXVector k = new FXVector();
    private float l;
    private float m = 0.0f;
    private static FXVector n = new FXVector();
    private static FXVector o = new FXVector();
    private static FXVector p = new FXVector();

    public Spring(Body body, Body body2, FXVector fXVector, FXVector fXVector2, int n) {
        this.a = body;
        this.b = body2;
        this.c = fXVector;
        this.d = fXVector2;
        if (n < 0) {
            this.calcDistance();
            return;
        }
        this.e = n;
    }

    protected Spring(Spring spring, Body[] bodyArray) {
        if (bodyArray == null) {
            this.a = spring.a;
            this.b = spring.b;
        } else {
            this.a = bodyArray[spring.a.mId];
            this.b = bodyArray[spring.b.mId];
        }
        this.c = new FXVector(spring.c);
        this.d = new FXVector(spring.d);
        this.e = spring.e;
        this.mCoefficientFX = spring.mCoefficientFX;
        if (spring.mUserData != null) {
            this.mUserData = spring.mUserData.copy();
        }
    }

    public Constraint copy(Body[] bodyArray) {
        return new Spring(this, bodyArray);
    }

    private Spring() {
    }

    public static Spring loadSpring(PhysicsFileReader object, Vector vector, UserData userData) {
        Spring spring = new Spring();
        new Spring().a = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        spring.c = ((PhysicsFileReader)object).nextVector();
        spring.b = (Body)vector.elementAt(((PhysicsFileReader)object).next());
        spring.d = ((PhysicsFileReader)object).nextVector();
        spring.e = ((PhysicsFileReader)object).nextIntFX();
        spring.mCoefficientFX = ((PhysicsFileReader)object).nextIntFX();
        if (((PhysicsFileReader)object).getVersion() > 1792) {
            object = ((PhysicsFileReader)object).nextString();
            if (userData != null) {
                spring.mUserData = userData.createNewUserData((String)object, 4);
            }
        }
        return spring;
    }

    protected void calcDistance() {
        if (this.a != null && this.b != null) {
            this.a.getAbsoluePoint(this.c, o);
            this.b.getAbsoluePoint(this.d, p);
            FXVector fXVector = new FXVector(p);
            fXVector.subtract(o);
            this.e = fXVector.lengthFX();
        }
    }

    public void setCoefficient(int n) {
        this.mCoefficientFX = 1.0f * (float)n;
    }

    public void setCoefficientFX(float f2) {
        this.mCoefficientFX = f2;
    }

    public float getCoefficientFX() {
        return this.mCoefficientFX;
    }

    public void setCollisionLayer(int n) {
        this.a.addCollisionLayer(n);
        this.b.addCollisionLayer(n);
    }

    public FXVector getPoint1() {
        return this.a.getAbsoluePoint(this.c);
    }

    public void getPoint1(FXVector fXVector) {
        this.a.getAbsoluePoint(this.c, fXVector);
    }

    public FXVector getPoint2() {
        return this.b.getAbsoluePoint(this.d);
    }

    public void getPoint2(FXVector fXVector) {
        this.b.getAbsoluePoint(this.d, fXVector);
    }

    public FXVector getRawPoint1() {
        return this.c;
    }

    public FXVector getRawPoint2() {
        return this.d;
    }

    public Body getBody1() {
        return this.a;
    }

    public Body getBody2() {
        return this.b;
    }

    public void precalculate(float f2) {
        this.a.getAbsoluePoint(this.c, o);
        this.b.getAbsoluePoint(this.d, p);
        this.h.assignDiff(p, o);
        this.i = this.h.lengthFX();
        if (this.i == 0.0f) {
            return;
        }
        this.a.getRotationMatrix().mult(this.c, this.j);
        this.b.getRotationMatrix().mult(this.d, this.k);
        this.h.divideByFX(this.i);
        this.f = -(this.h.xFX * this.j.yFX - this.h.yFX * this.j.xFX);
        this.g = -(this.h.xFX * this.k.yFX - this.h.yFX * this.k.xFX);
        float f3 = this.a.getInvInertia2FX() * (this.f * this.f);
        float f4 = this.b.getInvInertia2FX() * (this.g * this.g);
        this.l = this.a.getInvMass2FX() + f3 + this.b.getInvMass2FX() + f4;
        if (this.mCoefficientFX > 0.0f) {
            f2 = -(this.mCoefficientFX * (this.e - this.i) / f2);
            Spring.n.xFX = this.h.xFX;
            Spring.n.yFX = this.h.yFX;
            n.multFX(f2);
            this.a.applyMomentumAt(n, this.j);
            n.mult(-1);
            this.b.applyMomentumAt(n, this.k);
        }
    }

    public boolean applyMomentum(float f2) {
        if (this.mCoefficientFX > 0.0f || this.l == 0.0f) {
            return true;
        }
        float f3 = this.a.mVelocityFX.xFX * this.h.xFX + this.a.mVelocityFX.yFX * this.h.yFX - this.a.mAngularVelocity2FX * this.f - (this.b.mVelocityFX.xFX * this.h.xFX + this.b.mVelocityFX.yFX * this.h.yFX) + this.b.mAngularVelocity2FX * this.g;
        f3 += 0.25f * (this.e - this.i) * f2;
        f2 = -(f3 / this.l);
        Spring.n.xFX = this.h.xFX;
        Spring.n.yFX = this.h.yFX;
        n.multFX(f2);
        this.a.applyMomentumAt(n, this.j);
        n.mult(-1);
        this.b.applyMomentumAt(n, this.k);
        this.m += f2;
        return Math.abs(f2) < 0.00390625f;
    }

    public void postStep() {
    }

    public int getDistance() {
        return (int)this.e;
    }

    public float getDistanceFX() {
        return this.e;
    }

    public void setDistanceFX(float f2) {
        if (f2 < 0.0f) {
            this.calcDistance();
            return;
        }
        this.e = f2;
    }

    public float getImpulseFX() {
        return this.m;
    }

    public boolean concernsBody(Body body) {
        return this.a == body || this.b == body;
    }

    public boolean equals(Constraint constraint) {
        return constraint instanceof Spring && ((Spring)constraint).a.equals(this.a) && ((Spring)constraint).b.equals(this.b) && ((Spring)constraint).c.xFX == this.c.xFX && ((Spring)constraint).c.yFX == this.c.yFX && ((Spring)constraint).d.xFX == this.d.xFX && ((Spring)constraint).d.yFX == this.d.yFX;
    }

    protected void setBody1(Body body) {
        this.a = body;
    }

    protected void setBody2(Body body) {
        this.b = body;
    }

    protected void setAbsolutePoint1(FXVector fXVector) {
        this.c = this.a.getRelativePoint(fXVector);
    }

    protected void setAbsolutePoint2(FXVector fXVector) {
        this.d = this.b.getRelativePoint(fXVector);
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public void setUserData(UserData userData) {
        this.mUserData = userData;
    }
}

