/*
 * Decompiled with CFR 0.152.
 */
package com.renderedideas.yourgamename;

import com.renderedideas.gamemanager.GameFont;
import com.renderedideas.gamemanager.GameManager;
import com.renderedideas.gamemanager.Point;
import com.renderedideas.platform.Bitmap;
import com.renderedideas.platform.Debug;
import com.renderedideas.yourgamename.LevelSelectView;
import javax.microedition.lcdui.Graphics;

class LevelBlock {
    public static Bitmap bitmapLockedBlock;
    public static Bitmap bitmapOpenBlock;
    public static Bitmap bitmapStar;
    public static GameFont font;
    private static Bitmap bitmapBlockStarBlack;
    public Point stringPosition;
    public Point blockPosition;
    public Point[] starPositions;
    public byte noOfStars;
    public byte levelID;
    public boolean isLocked;
    public String strLevelID;
    private boolean levelCleared;
    float starXPreOffset = 3.0f;
    float starXPostOffset = 0.15f;
    float starY = 15.25f;

    public LevelBlock(Point pos, byte lvlID, byte status) {
        this.levelID = lvlID;
        this.blockPosition = pos;
        this.strLevelID = lvlID + "";
        if (font == null) {
            font = new GameFont("fonts/commonFonts");
        }
        this.evaluateStatus(status);
        this.initializeStarPositions();
        this.initializeStringPositions();
    }

    private void evaluateStatus(byte status) {
        switch (status) {
            case 0: {
                this.isLocked = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.isLocked = false;
                this.levelCleared = true;
                this.noOfStars = status;
                break;
            }
            case 4: {
                this.isLocked = false;
                this.noOfStars = 0;
                break;
            }
            case 5: {
                this.isLocked = false;
                this.levelCleared = true;
                this.noOfStars = 0;
            }
        }
        if (this.levelID == 1) {
            this.isLocked = false;
        }
    }

    public void updateX(float scrollSpeed) {
        this.blockPosition.X += scrollSpeed;
        this.stringPosition.X += scrollSpeed;
        for (int i = 0; i < 3; ++i) {
        }
    }

    private void initializeStarPositions() {
        this.starPositions = new Point[3];
        float total_starXPreOffset = this.blockPosition.X + (float)LevelSelectView.getScreenWidthPercent(this.starXPreOffset);
        int total_starXPostOffset = LevelSelectView.getScreenWidthPercent(this.starXPostOffset);
        float total_starY = this.blockPosition.Y + (float)LevelSelectView.getScreenHeightPercent(this.starY);
        for (int i = 0; i < 3; ++i) {
        }
    }

    private void initializeStringPositions() {
        this.stringPosition = new Point(this.blockPosition.X, this.blockPosition.Y);
        this.stringPosition.X += (float)(bitmapOpenBlock.getWidth() / 2 - font.stringWidth(this.strLevelID) / 2);
        this.stringPosition.Y += (float)(bitmapOpenBlock.getHeight() / 2 - font.stringHeight());
    }

    public void drawLevelBlock(Graphics g2) {
        if (this.blockPosition.X + (float)bitmapOpenBlock.getWidth() < 0.0f || this.blockPosition.X > (float)GameManager.screenWidth) {
            return;
        }
        if (this.isLocked) {
            Bitmap.drawBitmap(g2, bitmapLockedBlock, (int)this.blockPosition.X, (int)this.blockPosition.Y);
        } else {
            Bitmap.drawBitmap(g2, bitmapOpenBlock, (int)this.blockPosition.X, (int)this.blockPosition.Y);
            font.drawString(this.strLevelID, g2, (int)this.stringPosition.X, (int)this.stringPosition.Y);
        }
    }

    public void resetFontAndStarPositions() {
        this.stringPosition.X = this.blockPosition.X + (float)(bitmapOpenBlock.getWidth() / 2) - (float)(font.stringWidth(this.strLevelID) / 2);
    }

    public void print() {
        Debug.print(this.toString());
    }

    public String toString() {
        return "levelID: " + this.levelID + ", Position: " + this.blockPosition.toString() + ", isLocked: " + this.isLocked;
    }

    public void deallocate() {
        this.stringPosition = null;
        this.blockPosition = null;
        this.starPositions = null;
        this.strLevelID = null;
    }

    public static void loadBitmaps() {
        bitmapLockedBlock = new Bitmap("level select/locked_level.png");
        bitmapOpenBlock = new Bitmap("level select/level_select.png");
    }

    public static void deallocateBitmaps() {
        bitmapLockedBlock = null;
        bitmapOpenBlock = null;
        bitmapStar = null;
        bitmapBlockStarBlack = null;
        font = null;
    }
}

