/*
 * Decompiled with CFR 0.152.
 */
package com.am.poo;

import com.academmedia.radiantjewels.GameView;
import com.am.activity.interfaces.ActivityInterface;
import com.am.activity.interfaces.ActivityListener;
import com.am.poo.MainMID;
import com.am.poo.game.Game;
import com.am.poo.game.RPS;
import com.am.poo.view.AboutView;
import com.am.poo.view.HelpView;
import com.am.poo.view.MainMenu;
import com.am.poo.view.PauseMenu;
import com.am.resad.Ad;
import com.am.resad.BannerSprite;
import com.am.tools.Logger;
import com.am.view.ALM;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class ActivityCanvas
extends GameCanvas
implements CommandListener,
ActivityListener {
    public static final boolean SHOW_BANNER = false;
    public static final int BANNER_HEIGHT = 0;
    public final boolean BANNER_SWITCH;
    public static final int EVENT_START_NEW_GAME = 1;
    public static final int EVENT_PAUSE_GAME = 2;
    public static final int EVENT_SHOWABOUT = 10;
    public static final int EVENT_SHOWHELP = 11;
    public static final int EVENT_SHOWMENU = 12;
    public static final int EVENT_SHOW_HIGHSCREEN = 13;
    public static final int EVENT_RESUME_GAME = 3;
    public static final int EVENT_MINI_GAME = 100500;
    public static final int EVENT_RPS = 228;
    public static final int INTERVAL = 30;
    public static final int EXIT_GAME = 20;
    public static final int SOUND_CHANGE = 21;
    public static final int SOUND_WIN = 35;
    public static final int SOUND_FAIL = 36;
    public static long lastFrameTime;
    public static float deltaTime;
    protected MainMID midlet;
    protected Command backCommand;
    private GameThread gameThread;
    private Game game;
    private ActivityInterface currentView;
    private ActivityInterface menuView;
    private ActivityInterface gameView;
    private ActivityInterface pauseView;
    private ActivityInterface aboutView;
    private ActivityInterface helpView;
    private GameView gameMiniView;
    private RPS rps;
    public boolean sound = true;
    public static int WIDTH;
    public static int HEIGHT;
    private final BannerSprite banner;

    public ActivityCanvas(MainMID midlet) {
        super(true);
        this.BANNER_SWITCH = true;
        Logger.log("ActivityCanvas(MainMID midlet)");
        Logger.increaseIndent();
        this.setFullScreenMode(true);
        this.midlet = midlet;
        WIDTH = this.getWidth();
        HEIGHT = this.getHeight();
        this.backCommand = new Command("Back", 2, 0);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
        Ad.createInstance(midlet, this.getWidth(), this.getHeight(), false);
        this.banner = Ad.getInstance().createBannerSprite(0, "center", "bottom");
        ALM.setDisplaySize(WIDTH, HEIGHT);
        Logger.decreaseIndent();
    }

    public void render() {
        Graphics g = this.getGraphics();
        this.paint(g);
        this.flushGraphics();
    }

    protected void showNotify() {
        Logger.log("ActivityCanvas.showNotify()");
        Logger.increaseIndent();
        this.startApp();
        Logger.decreaseIndent();
    }

    protected void init() {
        Logger.log("ActivityCanvas.init()");
        Logger.increaseIndent();
        if (this.menuView == null) {
            this.menuView = new MainMenu(this, WIDTH, HEIGHT);
            this.menuView.initResources();
        }
        if (this.game == null) {
            this.game = new Game(this, WIDTH, HEIGHT);
            this.game.initResources();
        }
        if (this.aboutView == null) {
            this.aboutView = new AboutView(this, WIDTH, HEIGHT);
            this.aboutView.initResources();
        }
        if (this.helpView == null) {
            this.helpView = new HelpView(this, WIDTH, HEIGHT);
            this.helpView.initResources();
        }
        if (this.pauseView == null) {
            this.pauseView = new PauseMenu(this, WIDTH, HEIGHT);
            this.pauseView.initResources();
        }
        if (this.gameMiniView == null) {
            this.gameMiniView = new GameView(this, WIDTH, HEIGHT);
            System.out.println("ActivityCanvas.GameView.initResources()...");
            this.gameMiniView.initResources();
            System.out.println("ActivityCanvas.GameView.initResources()...");
        }
        if (this.rps == null) {
            this.rps = new RPS(this, WIDTH, HEIGHT);
            System.out.println("ActivityCanvas.RPS.initResources()...");
            this.rps.initResources();
            System.out.println("ActivityCanvas.RPS.initResources()...");
        }
        Logger.decreaseIndent();
    }

    protected void hideNotify() {
        Logger.log("ActivityCanvas.hideNotify()");
        Logger.increaseIndent();
        this.game.pauseGame();
        this.pauseApp();
        Logger.decreaseIndent();
    }

    public void stopApp() {
        this.gameThread.requestStop();
    }

    public void startApp() {
        Logger.log("ActivityCanvas.startApp()");
        Logger.increaseIndent();
        if (this.gameThread == null) {
            this.gameThread = new GameThread();
        }
        if (this.currentView == null) {
            this.changeView(this.menuView);
        }
        if (this.currentView == this.game) {
            this.changeView(this.pauseView);
        }
        this.gameThread.requestStart();
        Logger.decreaseIndent();
    }

    public void pauseApp() {
        Logger.log("ActivityCanvas.pauseApp()");
        Logger.increaseIndent();
        if (this.currentView == this.game) {
            this.game.pauseGame();
        }
        this.gameThread.requestPause();
        Logger.decreaseIndent();
    }

    public void commandAction(Command c, Displayable d) {
        Logger.log("ActivityCanvas.commandAction()");
        Logger.increaseIndent();
        if (c == this.backCommand) {
            if (this.currentView == this.menuView) {
                this.midlet.exit();
            }
            if (this.currentView == this.game) {
                this.game.pauseGame();
                this.changeView(this.pauseView);
            } else if (this.currentView == this.pauseView) {
                this.changeView(this.game);
                this.handleEvent(3);
            } else if (this.currentView == this.gameMiniView) {
                this.changeView(this.game);
                this.handleEvent(1);
            } else if (this.currentView == this.rps) {
                this.changeView(this.game);
                this.handleEvent(1);
            } else {
                this.changeView(this.menuView);
            }
        }
        Logger.decreaseIndent();
    }

    public void changeView(ActivityInterface targetView) {
        Logger.log("ActivityCanvas.changeView(" + targetView.toString() + ")");
        Logger.increaseIndent();
        if (this.currentView == this.game && targetView != this.game) {
            this.game.pauseGame();
        }
        this.currentView = targetView;
        Logger.decreaseIndent();
    }

    public void paint(Graphics g) {
        g.setColor(-16777216);
        try {
            if (this.currentView != null) {
                this.currentView.paint(g, 0, 0);
            }
            this.banner.paint(g);
        }
        catch (NullPointerException var3) {
            var3.printStackTrace();
        }
    }

    public void changeState(int state) {
    }

    public void handleEvent(int event) {
        Logger.log("ActivityCanvas.handleEvent ( " + event + " )");
        Logger.increaseIndent();
        switch (event) {
            case 1: {
                this.gameView = this.game;
                this.changeView(this.gameView);
                this.game.startGame();
                break;
            }
            case 2: {
                this.game.pauseGame();
                this.changeView(this.pauseView);
                break;
            }
            case 3: {
                this.game.resumeGame();
                this.changeView(this.game);
                break;
            }
            case 10: {
                this.game.pauseGame();
                this.changeView(this.aboutView);
                break;
            }
            case 11: {
                this.game.pauseGame();
                this.changeView(this.helpView);
                break;
            }
            case 12: {
                this.game.pauseGame();
                this.changeView(this.menuView);
                break;
            }
            case 20: {
                this.game.pauseGame();
                this.stopApp();
                this.midlet.exit();
                break;
            }
            case 21: {
                this.sound = !this.sound;
                this.menuView.refreshResources();
            }
            default: {
                break;
            }
            case 228: {
                System.out.println("EVENT_RPS");
                this.rps.refreshResources();
                this.changeView(this.rps);
                break;
            }
            case 100500: {
                System.out.println("EVENT_MINI_GAME");
                this.gameMiniView.refreshResources();
                this.changeView(this.gameMiniView);
            }
        }
        Logger.decreaseIndent();
    }

    public void pointerPressed(int x, int y) {
        if (!this.banner.touchDown(x, y)) {
            this.currentView.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (!this.banner.touchUp(x, y)) {
            this.currentView.pointerReleased(x, y);
        } else if (this.currentView == this.game) {
            this.handleEvent(2);
        }
    }

    public void pointerDragged(int x, int y) {
        this.currentView.pointerDragged(x, y);
    }

    static Game access$0(ActivityCanvas var0) {
        return var0.game;
    }

    class GameThread
    extends Thread {
        private boolean pause = true;
        private boolean stop = false;
        private boolean started = false;

        GameThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestStart() {
            lastFrameTime = this.currentTime();
            this.pause = false;
            if (!this.started) {
                this.start();
                this.started = true;
            } else {
                GameThread gameThread = this;
                synchronized (gameThread) {
                    this.notify();
                }
            }
        }

        public void requestPause() {
            this.pause = true;
        }

        public void requestStop() {
            this.stop = true;
        }

        public long currentTime() {
            return System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long time = 0L;
            while (!this.stop) {
                try {
                    if (this.pause) {
                        GameThread gameThread = this;
                        synchronized (gameThread) {
                            this.wait();
                            continue;
                        }
                    }
                    time = System.currentTimeMillis();
                    deltaTime = (float)(this.currentTime() - lastFrameTime) / 1000.0f;
                    lastFrameTime = this.currentTime();
                    ActivityCanvas.this.game.updateGame();
                    ActivityCanvas.this.render();
                    time = 30L - (System.currentTimeMillis() - time);
                    Thread.sleep(time < 0L ? 0L : time);
                }
                catch (Exception exception) {}
            }
        }
    }
}

