/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.components;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Button
extends Sprite {
    boolean enabled = true;
    boolean pressed = false;
    protected ButtonListener listener;

    public Button(Image image, ButtonListener listener) {
        super(image);
        this.listener = listener;
    }

    public boolean pointerPressed(int x, int y) {
        if (this.isVisible() && this.enabled && this.contains(x, y)) {
            this.pressed = true;
            this.listener.buttonPressed();
            return true;
        }
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        if (this.pressed && this.isVisible() && this.enabled && this.contains(x, y)) {
            this.pressed = false;
            this.listener.buttonReleased();
            return true;
        }
        this.pressed = false;
        return false;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    protected boolean contains(int x, int y) {
        return x >= this.getX() && x <= this.getX() + this.getWidth() && y >= this.getY() && y <= this.getY() + this.getHeight();
    }

    public static interface ButtonListener {
        public void buttonPressed();

        public void buttonReleased();
    }
}

