/*
 * Decompiled with CFR 0.152.
 */
package com.am.activity.main;

import com.am.activity.components.NewButton;
import com.am.activity.interfaces.ButtonInterface;
import com.am.activity.interfaces.OnButtonListener;
import java.util.Vector;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public abstract class Activity
extends LayerManager
implements OnButtonListener {
    public Vector buttons = new Vector();
    public int activityWidth;
    public int activityHeight;

    public Activity(int width, int height) {
        this.activityWidth = width;
        this.activityHeight = height;
    }

    public final int getID(ButtonInterface o) {
        int index = this.buttons.indexOf(o);
        return index;
    }

    public NewButton getButtonFromID(int index) {
        NewButton but = (NewButton)this.buttons.elementAt(index);
        return but;
    }

    public void addButton(ButtonInterface o) {
        this.buttons.addElement(o);
        Sprite sp = (Sprite)o;
        if (sp != null) {
            this.append((Layer)sp);
        }
    }

    public void addTextField(ButtonInterface o) {
        this.buttons.addElement(o);
    }

    public void removeTextField(ButtonInterface o) {
        int i = this.buttons.indexOf(o);
        if (i >= 0) {
            this.buttons.removeElementAt(i);
        }
    }

    public void removeButton(ButtonInterface o) {
        Sprite sp;
        int i = this.buttons.indexOf(o);
        if (i >= 0) {
            this.buttons.removeElementAt(i);
        }
        if ((sp = (Sprite)o) != null) {
            this.remove((Layer)sp);
        }
        for (int j = 0; j < this.buttons.size(); ++j) {
            ((NewButton)this.buttons.elementAt((int)j)).buttonID = this.getID((NewButton)this.buttons.elementAt(j));
        }
    }

    public final void notifyPointerPressed(int x, int y) {
        if (!this.buttons.isEmpty()) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                ButtonInterface observer = (ButtonInterface)this.buttons.elementAt(i);
                observer.pointerPressed(x, y);
            }
        }
    }

    public final void notifyPointerReleased(int x, int y) {
        if (!this.buttons.isEmpty()) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                ButtonInterface observer = (ButtonInterface)this.buttons.elementAt(i);
                observer.pointerReleased(x, y);
            }
        }
    }

    public final void notifyPointerDragged(int x, int y) {
        if (!this.buttons.isEmpty()) {
            for (int i = 0; i < this.buttons.size(); ++i) {
                ButtonInterface observer = (ButtonInterface)this.buttons.elementAt(i);
                observer.pointerDragged(x, y);
            }
        }
    }

    public boolean pointerPressed(int x, int y) {
        this.notifyPointerPressed(x, y);
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        this.notifyPointerReleased(x, y);
        return false;
    }

    public boolean pointerDragged(int x, int y) {
        this.notifyPointerDragged(x, y);
        return false;
    }

    public int getActivityWidth() {
        return this.activityWidth;
    }

    public int getActivityHeight() {
        return this.activityHeight;
    }

    public abstract void buttonIsPressed(int var1);

    public abstract void buttonIsReleased(int var1);

    public abstract void buttonIsDragged(int var1, int var2, int var3);

    public abstract void returnState(int var1, int var2);
}

