/*
 * Decompiled with CFR 0.152.
 */
package com.am.resad;

import com.am.resad.AdData;
import com.am.resad.Banner;
import com.am.resad.BannerListener;
import com.am.resad.BannerSprite;
import com.am.resad.Log;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public final class Ad {
    private static final int FPS = 7;
    private static final long FRAME_INTERVAL = 142L;
    private static boolean loggingEnabled = false;
    private static int currentBannerIndex = -1;
    private static Ad instance;
    private boolean enabled = true;
    private int screenWidth;
    private int screenHeight;
    private MIDlet midlet;
    private Timer bannerTimer;
    private BannerSprite bannerSprite = null;
    private static final Image defaultImage;
    private final Vector bannerListeners = new Vector();
    static /* synthetic */ Class class$com$am$resad$Ad;

    public static boolean isLoggingEnabled() {
        return loggingEnabled;
    }

    public static void setLoggingEnabled(boolean aLoggingEnabled) {
        loggingEnabled = aLoggingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.startAd();
        } else {
            this.stopAd();
        }
        Vector vector = this.bannerListeners;
        synchronized (vector) {
            int n = this.bannerListeners.size();
            for (int i = 0; i < n; ++i) {
                WeakReference ref = (WeakReference)this.bannerListeners.elementAt(i);
                BannerListener listener = (BannerListener)ref.get();
                if (listener == null) continue;
                listener.setEnabled(enabled);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static Ad getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Ad was not initialized. Call Ad.createInstance before Ad.getInstance");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ad createInstance(MIDlet midlet, int screenWidth, int screenHeight, boolean enabled) {
        Class clazz = class$com$am$resad$Ad == null ? (class$com$am$resad$Ad = Ad.class$("com.am.resad.Ad")) : class$com$am$resad$Ad;
        synchronized (clazz) {
            if (instance == null) {
                instance = new Ad(midlet, screenWidth, screenHeight, enabled);
                instance.startAd();
            }
            return instance;
        }
    }

    private Ad(MIDlet midlet, int screenWidth, int screenHeight, boolean enabled) {
        this.midlet = midlet;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.enabled = enabled;
    }

    void openLink() {
        if (!this.enabled) {
            return;
        }
        try {
            AdData data = AdData.getInstance();
            if (currentBannerIndex == -1) {
                return;
            }
            Banner banner = data.getBanner(currentBannerIndex);
            String link = banner.getLink();
            this.midlet.platformRequest(link);
        }
        catch (Exception e) {
            Log.e(e.toString());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBannerListener(BannerListener listener) {
        Vector vector = this.bannerListeners;
        synchronized (vector) {
            this.bannerListeners.addElement(new WeakReference<BannerListener>(listener));
        }
    }

    public BannerSprite createBannerSprite() {
        return this.createBannerSprite(0, "center", "bottom");
    }

    public void setScreenSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("Illegal width: " + width);
        }
        if (height < 0) {
            throw new IllegalArgumentException("Illegal height: " + height);
        }
        this.screenWidth = width;
        this.screenHeight = height;
    }

    public BannerSprite createBannerSprite(int angle, String alignX, String alignY) {
        Image image = currentBannerIndex < 0 ? defaultImage : AdData.getInstance().getBanner(currentBannerIndex).getImage();
        this.bannerSprite = new BannerSprite(image, angle, alignX, alignY, this.screenWidth, this.screenHeight);
        BannerListener listener = this.bannerSprite.getBannerListener();
        this.addBannerListener(listener);
        listener.setEnabled(this.enabled);
        return this.bannerSprite;
    }

    private void startAd() {
        this.startBannerTimer(0, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAd() {
        this.stopBannerTimer();
        Vector vector = this.bannerListeners;
        synchronized (vector) {
            int n = this.bannerListeners.size();
            for (int i = 0; i < n; ++i) {
                WeakReference ref = (WeakReference)this.bannerListeners.elementAt(i);
                BannerListener listener = (BannerListener)ref.get();
                if (listener == null) continue;
                listener.imageReceived(defaultImage);
            }
        }
    }

    private void startBannerTimer(int delay, int period) {
        if (this.enabled && this.bannerTimer == null) {
            Log.i("START BANNER TIMER: " + delay + ", " + period);
            this.bannerTimer = new Timer();
            this.bannerTimer.schedule((TimerTask)new BannerImageChangeTask(), delay * 1000, (long)(period * 1000));
            this.bannerTimer.schedule((TimerTask)new FrameChangeTask(), 0L, 142L);
        }
    }

    private void stopBannerTimer() {
        Timer bannerTimer = this.bannerTimer;
        if (bannerTimer != null) {
            bannerTimer.cancel();
            this.bannerTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeallocatedListeners() {
        Vector vector = this.bannerListeners;
        synchronized (vector) {
            for (int i = this.bannerListeners.size() - 1; i > 0; --i) {
                WeakReference ref = (WeakReference)this.bannerListeners.elementAt(i);
                BannerListener listener = (BannerListener)ref.get();
                if (listener != null) continue;
                this.bannerListeners.removeElementAt(i);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultImage = Image.createImage((int)1, (int)1);
    }

    private class FrameChangeTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Vector vector = Ad.this.bannerListeners;
            synchronized (vector) {
                int n = Ad.this.bannerListeners.size();
                for (int i = 0; i < n; ++i) {
                    WeakReference ref = (WeakReference)Ad.this.bannerListeners.elementAt(i);
                    BannerListener listener = (BannerListener)ref.get();
                    if (listener == null) continue;
                    listener.nextFrame();
                }
            }
        }
    }

    private class BannerImageChangeTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.i("BANNER TIMER TIMEOUT");
            if (!Ad.this.enabled) {
                Ad.this.stopBannerTimer();
                return;
            }
            currentBannerIndex = AdData.getInstance().getRandomBannerIndex(currentBannerIndex);
            if (currentBannerIndex < 0) {
                return;
            }
            Banner banner = AdData.getInstance().getBanner(currentBannerIndex);
            if (banner == null) {
                return;
            }
            Ad.this.removeDeallocatedListeners();
            Vector vector = Ad.this.bannerListeners;
            synchronized (vector) {
                int n = Ad.this.bannerListeners.size();
                if (n == 0) {
                    return;
                }
                Image image = banner.getImage();
                for (int i = 0; i < n; ++i) {
                    WeakReference ref = (WeakReference)Ad.this.bannerListeners.elementAt(i);
                    BannerListener listener = (BannerListener)ref.get();
                    if (listener == null) continue;
                    listener.imageReceived(image);
                }
            }
        }
    }
}

