/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.gui;

import com.creativenorth.base.Core;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNImage;
import com.creativenorth.graphics.CNMosaic;
import com.creativenorth.graphics.CNText;
import com.creativenorth.gui.Button;
import com.creativenorth.gui.List;
import com.creativenorth.gui.Menu;
import com.creativenorth.io.Stream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import schoolfriends.SchoolCore;

public class ScreenObject {
    protected static ScreenObject[] allScreenObjects;
    protected static int screenObjectCount;
    public static final int TYPE_BASIC = 0;
    public static final int TYPE_MENU = 1;
    public static final int TYPE_BUTTON = 2;
    public static final int TYPE_GAME = 3;
    public static final int TYPE_LIST = 4;
    protected int m_objectType = 0;
    protected boolean visible;
    protected boolean opaque;
    protected boolean usesImage;
    protected boolean usesText;
    protected boolean hasChildren;
    protected boolean usesBorder;
    protected int borderStyle;
    protected int borderColor;
    protected int borderImage;
    protected boolean usesSeed;
    protected int seed;
    protected boolean isSelectable;
    protected int selectedColor;
    protected int borderImageSelected;
    protected boolean m_hasHBar;
    protected int m_hBarPos;
    protected int m_hBarCol;
    protected int boundsX;
    protected int boundsY;
    protected int boundsWidth;
    protected int boundsHeight;
    protected int marginX;
    protected int marginY;
    protected boolean transparent;
    protected int color;
    protected int imageX;
    protected int imageY;
    protected int image = -1;
    protected int wrapping;
    protected Image m_image;
    protected int mosaicBackground;
    protected int fragmentBackground;
    protected int text = 255;
    protected int font;
    protected int textAlign;
    protected ScreenObject[] children;
    protected boolean m_bSelected = false;
    protected int id = -1;
    protected boolean m_bWrapBounce = false;
    protected int m_iWrapBouncePadding;
    protected int m_iBounceOffset;
    protected int m_iBounceDir;
    protected int m_iBounceMax;
    protected int m_iBounceMin;
    private int m_iColorScrollBackground;
    private int m_iColorScrollTab;
    private int m_iColorScrollArrows;
    private int m_iScrollSize;
    private int m_iScrollSpacer;
    private int m_iScrollTabTop;
    private int m_iScrollTabHeight;
    private int m_iScrollBarMaximum;
    private int m_iScrollBarVisible;
    private int m_iScrollTabAreaHeight;
    private int m_iDistanceFromTop;
    public boolean m_bScrollNeeded;
    private boolean m_bShadowOn = false;
    private int m_iDropShadowX = 2;
    private int m_iDropShadowY = 1;
    private int m_iDropShadowColor = 0x800080;

    public void load(Stream stream) throws IOException {
        this.id = screenObjectCount++;
        ScreenObject.allScreenObjects[this.id] = this;
        int flags = stream.readU16();
        this.visible = (flags & 1) != 1;
        this.opaque = (flags & 2) == 2;
        this.usesImage = (flags & 4) == 4;
        this.usesText = (flags & 8) == 8;
        this.hasChildren = (flags & 0x10) == 16;
        this.usesBorder = (flags & 0x20) == 32;
        this.usesSeed = (flags & 0x40) == 64;
        this.isSelectable = (flags & 0x80) == 128;
        this.m_hasHBar = (flags & 0x100) == 256;
        this.boundsX = stream.readS16();
        this.boundsY = stream.readS16();
        this.boundsWidth = stream.readU16();
        this.boundsHeight = stream.readU16();
        if (!this.visible) {
            stream.readU16();
        }
        if (this.opaque) {
            this.color = stream.readU24();
        }
        this.imageX = this.boundsX + stream.readS16();
        this.imageY = this.boundsY + stream.readS16();
        if (this.usesImage) {
            this.image = stream.readU16();
            this.wrapping = stream.readU8();
            this.mosaicBackground = stream.readS16();
            this.fragmentBackground = stream.readS16();
        }
        if (this.usesText) {
            this.text = stream.readU16();
            this.font = stream.readU8();
            this.textAlign = stream.readU8();
            CNText.recalcNewlines(this.text, this.getWidth());
        }
        if (this.usesBorder) {
            this.borderStyle = stream.readU8();
            if (this.borderStyle == 1) {
                this.borderColor = stream.readU24();
            } else if (this.borderStyle == 2) {
                this.borderImage = stream.readU16();
                this.borderImageSelected = stream.readU16();
            }
        }
        if (this.usesSeed) {
            this.seed = stream.readU8();
        }
        if (this.isSelectable) {
            this.selectedColor = stream.readU24();
        }
        if (this.m_hasHBar) {
            this.m_hBarPos = this.boundsY + stream.readU16();
            this.m_hBarCol = stream.readU24();
        }
        if (this.hasChildren) {
            int kids = stream.readU8();
            this.children = new ScreenObject[kids];
            for (int child = 0; child < this.children.length; ++child) {
                int type = stream.readU8();
                if (type == 0) {
                    this.children[child] = new ScreenObject();
                    this.children[child].load(stream);
                    if (SchoolCore.GMG_MENU || this.children[child].id != 15) continue;
                    this.children[child].boundsHeight -= 15;
                    continue;
                }
                if (type == 2) {
                    Button b = new Button();
                    this.children[child] = b;
                    b.load(stream);
                    if (b.m_trigger == 0) {
                        if (!SchoolCore.GMG_MENU) {
                            if (this.children[child].id != 22) {
                                Menu.currentMenu.addButton(b);
                            } else {
                                b.visible = false;
                            }
                            if (this.children[child].id != 23) continue;
                            b.shiftY(-15);
                            continue;
                        }
                        Menu.currentMenu.addButton(b);
                        continue;
                    }
                    if (b.m_trigger == 1) {
                        Menu.currentMenu.setLSK(b);
                        continue;
                    }
                    if (b.m_trigger != 2) continue;
                    Menu.currentMenu.setRSK(b);
                    continue;
                }
                if (type == 4) {
                    List l = new List();
                    this.children[child] = l;
                    l.load(stream);
                    Menu.currentMenu.addButton(l);
                    continue;
                }
                if (type != 3) continue;
                this.children[child] = Core.me.loadUniqueScreenObject(stream.readU8(), stream);
            }
        }
        this.setWrapBouncePadding(3);
    }

    public static boolean isInvalid(int _id) {
        return allScreenObjects[_id] == null;
    }

    public static ScreenObject getObject(int _id) {
        if (ScreenObject.isInvalid(_id)) {
            return null;
        }
        return allScreenObjects[_id];
    }

    public static void set(int _id, ScreenObject _so) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        if (allScreenObjects == null) {
            return;
        }
        int i = allScreenObjects.length;
        while (i-- > 0) {
            if (allScreenObjects[i] == null || ScreenObject.allScreenObjects[i].children == null) continue;
            int j = ScreenObject.allScreenObjects[i].children.length;
            while (j-- > 0) {
                if (ScreenObject.allScreenObjects[i].children[j] != allScreenObjects[_id]) continue;
                ScreenObject.allScreenObjects[i].children[j] = _so;
            }
        }
        ScreenObject.allScreenObjects[_id] = _so;
    }

    public static final boolean isEnabled(int _id) {
        if (ScreenObject.isInvalid(_id)) {
            return false;
        }
        return ScreenObject.allScreenObjects[_id].isSelectable;
    }

    public static void setBackground(int _id, Image _image) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        ScreenObject.allScreenObjects[_id].m_image = _image;
    }

    public static void setBackground(int _id, int _mosaic, int _fragment) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        ScreenObject.allScreenObjects[_id].mosaicBackground = _mosaic;
        ScreenObject.allScreenObjects[_id].fragmentBackground = _fragment;
    }

    public static void show(int _id) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        ScreenObject.allScreenObjects[_id].visible = true;
    }

    public static void hide(int _id) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        ScreenObject.allScreenObjects[_id].visible = false;
    }

    public static boolean toggle(int _id) {
        if (ScreenObject.isInvalid(_id)) {
            return false;
        }
        return allScreenObjects[_id].toggle();
    }

    public static boolean isVisible(int _id) {
        if (ScreenObject.isInvalid(_id)) {
            return false;
        }
        return ScreenObject.allScreenObjects[_id].visible;
    }

    public static void setAsSelected(int _id) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        allScreenObjects[_id].highlight();
    }

    public static void setAsUnselected(int _id) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        allScreenObjects[_id].lowlight();
    }

    public static void SetShadow(int _id, int _x, int _y) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        allScreenObjects[_id].setShadow(_x, _y);
    }

    public static int wrap(int _id) {
        if (ScreenObject.isInvalid(_id)) {
            return 0;
        }
        return CNText.recalcNewlines(ScreenObject.allScreenObjects[_id].text, ScreenObject.allScreenObjects[_id].boundsWidth);
    }

    public static void setWidth(int _id, int _width) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        ScreenObject.allScreenObjects[_id].boundsWidth = _width;
    }

    public static void setText(int _id, int _text) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        ScreenObject.allScreenObjects[_id].text = _text;
    }

    public static void setHeight(int _id, int _height) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        ScreenObject.allScreenObjects[_id].boundsHeight = _height;
    }

    public static void opaque(int _id, boolean _b) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        ScreenObject.allScreenObjects[_id].opaque = _b;
    }

    public void disable() {
        this.isSelectable = false;
    }

    public void enable() {
        this.isSelectable = true;
    }

    public boolean isEnabled() {
        return this.isSelectable;
    }

    public final void setWidth(int _w) {
        this.boundsWidth = _w;
    }

    public final void setHeight(int _h) {
        this.boundsHeight = _h;
    }

    public final int getX() {
        return this.boundsX;
    }

    public final int getY() {
        return this.boundsY;
    }

    public final void shiftY(int _y) {
        if (this.children != null) {
            int i = this.children.length;
            while (i-- > 0) {
                this.children[i].shiftY(_y);
            }
        }
        this.imageY += _y;
        this.boundsY += _y;
    }

    public final int getTextRef() {
        return this.text;
    }

    public final void show() {
        this.visible = true;
    }

    public final void hide() {
        this.visible = false;
    }

    public final boolean toggle() {
        return ScreenObject.allScreenObjects[this.id].visible ^= true;
    }

    public final void makeOpaque() {
        this.opaque = true;
    }

    public final void setBGColor(int _col) {
        this.color = _col;
    }

    public final int getBGColor() {
        return this.color;
    }

    public void setWrapBouncePadding(int _padding) {
        this.m_iWrapBouncePadding = _padding << 1;
    }

    public void enableWrapBounce() {
        CNText.setFont(this.font);
        CNText.recalcWidth(this.text);
        int bounceAmount = CNText.m_widths[this.text] - (this.boundsWidth - this.m_iWrapBouncePadding);
        this.m_bWrapBounce = bounceAmount > 0;
        this.m_iBounceDir = 1;
        if (this.textAlign == 2) {
            this.m_iBounceMax = bounceAmount >> 1;
            this.m_iBounceMin = -this.m_iBounceMax;
        } else {
            this.m_iBounceMax = bounceAmount;
            this.m_iBounceMin = 0;
        }
    }

    public void highlight() {
        this.m_bSelected = true;
        this.enableWrapBounce();
    }

    public void lowlight() {
        this.m_bSelected = false;
    }

    public int getWidth() {
        return this.boundsWidth;
    }

    public int getHeight() {
        return this.boundsHeight;
    }

    public void render(CNGraphics graphics) {
        if (Core.me == null) {
            return;
        }
        if (this.visible) {
            graphics.setClip(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
            if (this.opaque) {
                if (!this.isSelectable && this.m_objectType == 2) {
                    graphics.setColor(0x808080);
                } else if (this.m_bSelected) {
                    graphics.setColor(this.selectedColor);
                } else {
                    graphics.setColor(this.color);
                }
                graphics.fillRect(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
            }
            if (this.usesImage) {
                if (this.mosaicBackground >= 0) {
                    int w = CNMosaic.mosaics[this.mosaicBackground].getWidth(this.fragmentBackground);
                    int h = CNMosaic.mosaics[this.mosaicBackground].getHeight(this.fragmentBackground);
                    switch (this.wrapping) {
                        case 0: {
                            int y;
                            int x;
                            CNMosaic.mosaics[this.mosaicBackground].draw(graphics.m_graphics, this.fragmentBackground, x, y);
                            break;
                        }
                        case 1: {
                            int y;
                            int x;
                            for (x = this.imageX; x < this.imageX + this.boundsWidth; x += w) {
                                CNMosaic.mosaics[this.mosaicBackground].draw(graphics.m_graphics, this.fragmentBackground, x, y);
                            }
                            break;
                        }
                        case 2: {
                            int y;
                            int x;
                            for (y = this.imageY; y < this.imageY + this.boundsHeight; y += h) {
                                CNMosaic.mosaics[this.mosaicBackground].draw(graphics.m_graphics, this.fragmentBackground, x, y);
                            }
                            break;
                        }
                        case 3: {
                            int y;
                            int x;
                            while (x < this.imageX + this.boundsWidth) {
                                for (y = this.imageY; y < this.imageY + this.boundsHeight; y += h) {
                                    CNMosaic.mosaics[this.mosaicBackground].draw(graphics.m_graphics, this.fragmentBackground, x, y);
                                }
                                x += w;
                            }
                            break;
                        }
                    }
                } else {
                    CNImage img = Core.me.menuScripts.getImage(this.image);
                    int w = img.getWidth();
                    int h = img.getHeight();
                    switch (this.wrapping) {
                        case 0: {
                            int y;
                            int x;
                            graphics.drawImage(img, x, y, 0);
                            break;
                        }
                        case 1: {
                            int y;
                            int x;
                            for (x = this.imageX; x < this.imageX + this.boundsWidth; x += w) {
                                graphics.drawImage(img, x, y, 0);
                            }
                            break;
                        }
                        case 2: {
                            int y;
                            int x;
                            for (y = this.imageY; y < this.imageY + this.boundsHeight; y += h) {
                                graphics.drawImage(img, x, y, 0);
                            }
                            break;
                        }
                        case 3: {
                            int y;
                            int x;
                            while (x < this.imageX + this.boundsWidth) {
                                for (y = this.imageY; y < this.imageY + this.boundsHeight; y += h) {
                                    graphics.drawImage(img, x, y, 0);
                                }
                                x += w;
                            }
                            break;
                        }
                    }
                }
            }
            if (this.m_image != null) {
                graphics.m_graphics.drawImage(this.m_image, this.imageX, this.imageY, 0);
            }
            if (this.usesText) {
                CNText.setFont(this.font);
                int newX = this.imageX;
                if (this.textAlign == 2) {
                    CNText.recalcWidth(this.text);
                    newX += this.boundsWidth - CNText.m_widths[this.text] >> 1;
                }
                if (this.m_bSelected || this.m_bWrapBounce) {
                    if (this.m_iBounceMax - this.m_iBounceMin > 0) {
                        long t = System.currentTimeMillis() / 100L % (long)(this.m_iBounceMax - this.m_iBounceMin << 1) + (long)this.m_iBounceMin;
                        newX = (int)((long)newX - (t < (long)this.m_iBounceMax ? t : (long)this.m_iBounceMax - (t - (long)this.m_iBounceMax)));
                    }
                } else if (this.m_objectType == 4) {
                    newX -= this.m_iBounceMin;
                }
                if (this.m_bScrollNeeded) {
                    CNText.drawString(this.text, newX, this.m_iDistanceFromTop, this.imageY, this.boundsHeight);
                } else {
                    CNText.drawString(this.text, newX, this.imageY - 1);
                }
            }
            if (this.usesBorder) {
                graphics.resetClip();
                if (this.borderStyle == 1) {
                    graphics.setColor(this.borderColor);
                    graphics.drawRect(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
                }
            }
            if (this.m_hasHBar) {
                graphics.setColor(this.m_hBarCol);
                graphics.drawLine(this.boundsX, this.m_hBarPos, this.boundsX + this.boundsWidth, this.m_hBarPos);
            }
            if (this.hasChildren) {
                this.renderChildren(graphics);
            }
            if (this.m_bScrollNeeded) {
                this.renderVerticalScrollBar(graphics.m_graphics, this.boundsX + this.boundsWidth, this.boundsY, this.boundsHeight);
            }
            if (this.m_bShadowOn) {
                this.renderDropShadow(graphics.m_graphics);
            }
        }
    }

    public void renderChildren(CNGraphics graphics) {
        if (this.children == null) {
            return;
        }
        for (int child = 0; child < this.children.length; ++child) {
            this.children[child].render(graphics);
        }
    }

    public void enableScrollBar(int _size, int _spacer, int _colBG, int _colTab, int _colArrow) {
        this.enableScrollBar(_size, _spacer, _colBG, _colTab, _colArrow, this.boundsHeight);
    }

    public void enableScrollBar(int _size, int _spacer, int _colBG, int _colTab, int _colArrow, int _height) {
        this.m_bScrollNeeded = true;
        this.boundsWidth -= _size + _spacer;
        this.m_iScrollSize = _size;
        this.m_iScrollSpacer = _spacer;
        this.m_iColorScrollBackground = _colBG;
        this.m_iColorScrollTab = _colTab;
        this.m_iColorScrollArrows = _colArrow;
        this.m_iScrollTabAreaHeight = _height - this.m_iScrollSize - this.m_iScrollSize - 2;
    }

    public void disableScrollBar() {
        this.boundsWidth += this.m_iScrollSize;
        this.m_iScrollSize = 0;
        this.m_iScrollSpacer = 0;
        this.m_iScrollBarMaximum = 0;
        this.m_iScrollBarVisible = 0;
        this.m_iScrollTabTop = 0;
        this.m_iScrollTabHeight = 0;
        this.m_bScrollNeeded = false;
    }

    public void renderVerticalScrollBar(Graphics _g, int _x, int _y, int _h) {
        _g.setClip(_x += this.m_iScrollSpacer, _y, this.m_iScrollSize, _h);
        _g.setColor(this.m_iColorScrollBackground);
        _g.fillRect(_x, _y, this.m_iScrollSize, _h);
        _g.setColor(this.m_iColorScrollTab);
        _g.fillRect(_x, _y, this.m_iScrollSize, this.m_iScrollSize);
        _g.fillRect(_x, _y + _h - this.m_iScrollSize, this.m_iScrollSize, this.m_iScrollSize);
        _g.setColor(this.m_iColorScrollArrows);
        Core.me.drawUpArrow(_g, _x + (this.m_iScrollSize >> 1), _y + 4, 4);
        Core.me.drawDownArrow(_g, _x + (this.m_iScrollSize >> 1), _y + _h - 4, 4);
        _g.setColor(this.m_iColorScrollTab);
        _g.fillRect(_x + 1, _y + this.m_iScrollTabTop, this.m_iScrollSize - 2, this.m_iScrollTabHeight);
    }

    public void setScrollBarPosition(int _position) {
        if (this.m_iScrollBarMaximum <= 0) {
            return;
        }
        if (_position < 0) {
            _position = 0;
        }
        if (_position > this.m_iScrollBarMaximum - this.m_iScrollBarVisible) {
            _position = this.m_iScrollBarMaximum - this.m_iScrollBarVisible;
        }
        this.m_iDistanceFromTop = _position;
        this.m_iScrollTabTop = this.m_iScrollSize + 1 + this.m_iDistanceFromTop * this.m_iScrollTabAreaHeight / this.m_iScrollBarMaximum;
    }

    public int getScrollBarPosition() {
        return this.m_iDistanceFromTop;
    }

    public void setScrollBarMaximum(int _maximum, int _visible) {
        this.m_iScrollBarMaximum = _maximum;
        this.m_iScrollBarVisible = _visible;
        this.m_iScrollTabHeight = this.m_iScrollBarMaximum > this.m_iScrollBarVisible ? this.m_iScrollBarVisible * this.m_iScrollTabAreaHeight / this.m_iScrollBarMaximum : 0;
        this.setScrollBarPosition(0);
    }

    public void setShadow(int _x, int _y) {
        this.setShadow(_x, _y, 0x800080);
    }

    public void setShadow(int _x, int _y, int _col) {
        this.m_iDropShadowX = _x;
        this.m_iDropShadowY = _y;
        this.m_iDropShadowColor = _col;
        this.m_bShadowOn = true;
    }

    protected void renderDropShadow(Graphics _g) {
        int w = this.boundsWidth + this.m_iScrollSize + this.m_iScrollSpacer;
        _g.setColor(this.m_iDropShadowColor);
        _g.setClip(this.boundsX + this.m_iDropShadowX, this.boundsY + this.m_iDropShadowY, w, this.boundsHeight);
        _g.fillRect(this.boundsX + w, this.boundsY + this.m_iDropShadowY, this.m_iDropShadowX, this.boundsHeight);
        _g.fillRect(this.boundsX + this.m_iDropShadowX, this.boundsY + this.boundsHeight, w, this.m_iDropShadowY);
    }
}

