/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends;

import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class CNPaletteShiftImage {
    static byte[] PNG_header = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 8, 3, 0, 0, 0, 0, 0, 0, 0};
    static final int PNG_PLTE = 1347179589;
    static final int PNG_IEND = 1229278788;
    static int[] crc_table = new int[256];

    public static Image createImage(String path, byte[] find, byte[] replace) throws IOException {
        int i;
        Image img = null;
        InputStream inp = path.getClass().getResourceAsStream(path);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (inp == null) {
            Log.addError("InputStream is null when trying to load '" + path + "' with a palette.");
        }
        for (int i2 = PNG_header.length - 1; i2 >= 0; --i2) {
            out.write(inp.read());
        }
        int size = CNImage.copy4ByteInt(inp, out);
        int name = CNImage.copy4ByteInt(inp, out);
        while (name != 1347179589) {
            for (int i3 = size + 4 - 1; i3 >= 0; --i3) {
                out.write(inp.read());
            }
            size = CNImage.copy4ByteInt(inp, out);
            name = CNImage.copy4ByteInt(inp, out);
            if (inp.available() >= 1) continue;
            IOException e = new IOException("java.lang.ArtistException: no palette in file " + path);
            Log.addExeption("No palette found in file.", e);
        }
        byte[] palette = new byte[size + 4];
        palette[0] = 80;
        palette[1] = 76;
        palette[2] = 84;
        palette[3] = 69;
        inp.read(palette, 4, size);
        block3: for (i = 4; i < size; i += 3) {
            for (int j = find.length - 3 - find.length % 3; j >= 0; j -= 3) {
                if (palette[i] != find[j] || palette[i + 1] != find[j + 1] || palette[i + 2] != find[j + 2]) continue;
                palette[i] = replace[j];
                palette[i + 1] = replace[j + 1];
                palette[i + 2] = replace[j + 2];
                continue block3;
            }
        }
        inp.skip(4L);
        out.write(palette, 4, size);
        CNImage.write4ByteInt(CNPaletteShiftImage.calc_crc(palette, 0, palette.length), out);
        while (name != 1229278788) {
            size = CNImage.copy4ByteInt(inp, out);
            name = CNImage.copy4ByteInt(inp, out);
            for (i = size + 4 - 1; i >= 0; --i) {
                out.write(inp.read());
            }
        }
        inp = null;
        byte[] b = out.toByteArray();
        int s = out.size();
        out = null;
        img = Image.createImage((byte[])b, (int)0, (int)s);
        return img;
    }

    static long calc_crc(byte[] buf, int off, int len) {
        int c = -1;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        return (long)(~c) & 0xFFFFFFFFL;
    }

    static {
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            CNPaletteShiftImage.crc_table[n] = c;
        }
    }
}

