/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.base;

import com.creativenorth.base.CoreMidlet;
import com.creativenorth.base.Timekeeper;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNText;
import com.creativenorth.gui.Menu;
import com.creativenorth.gui.MenuScriptsRoot;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.io.Stream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import schoolfriends.CNSound;
import schoolfriends.SchoolCore;

public abstract class Core
extends Canvas
implements Runnable {
    private static Timekeeper timekeeper;
    public static Core me;
    protected CoreMidlet m_midlet;
    public Thread thread;
    private boolean m_isRunning;
    protected boolean m_bPaused;
    private boolean m_bPainting;
    protected boolean m_bInitialLoad = false;
    protected CNGraphics m_graphics;
    private String manufacturer;
    private String version;
    public Random random;
    public MenuScriptsRoot menuScripts;
    private boolean m_bSoftsDisabled = false;
    public static final int CMD_NONE = 0;
    public static final int CMD_SELECT = 1;
    public static final int CMD_EXIT = 2;
    public static final int CMD_BACK = 3;
    private int m_keyMask;
    public static final int KEY_NONE = 0;
    public static final int KEY_UP = 1;
    public static final int KEY_RIGHT = 2;
    public static final int KEY_DOWN = 4;
    public static final int KEY_LEFT = 8;
    public static final int KEY_FIRE = 16;
    public static final int KEY_LSK = 32;
    public static final int KEY_RSK = 64;
    public static final int KEY_UPLEFT = 128;
    public static final int KEY_UPRIGHT = 256;
    public static final int KEY_DOWNLEFT = 512;
    public static final int KEY_DOWNRIGHT = 1024;
    public static final int KEY_HASH = 2048;
    public static final int KEY_STAR = 4096;
    private static final int LOADBAR_HEIGHT = 10;
    private int m_iPrerunLoadPercent = 0;
    public Image img;
    public static final int INPUT_LSK = -6;
    public static final int INPUT_RSK = -7;
    CNSound bgm1;
    public static boolean first;
    public int m_iState = 0;
    public static final int STATE_NONE = 0;
    public static final int STATE_PRERUNLOAD = 1;
    public static final int STATE_RUNNING = 2;
    public static final int STATE_ERROR = 3;
    private Vector m_strError;

    public static Timekeeper getTimekeeper() {
        if (timekeeper == null) {
            timekeeper = new Timekeeper();
        }
        return timekeeper;
    }

    public abstract void onMenuChange();

    public abstract void setScreenSize(int var1, int var2);

    public abstract void drawButton(CNGraphics var1, int var2, int var3, int var4, boolean var5);

    public abstract boolean onKeyDown(int var1);

    public abstract boolean onKeyUp(int var1);

    public abstract boolean onKeyHeld(int var1);

    public abstract boolean onNumberKey(int var1);

    public abstract boolean afterKeyPressed(int var1);

    public abstract void onListChange(int var1, int var2, int var3);

    public abstract Image createImageFromCommand(int var1);

    public abstract void drawSoftkey(CNGraphics var1, int var2, int var3);

    public void logicLoop() {
    }

    public void setLoadPercent(int _percent) {
        this.m_iPrerunLoadPercent = _percent;
        this.forceRepaint();
    }

    protected void prerunRender(Graphics _g) {
    }

    protected void prerunRender1(Graphics _g) {
        int w = 100;
        int h = 10;
        int x = CNGraphics.SCREEN_WIDTH - w >> 1;
        int y = CNGraphics.SCREEN_HEIGHT - h >> 1;
        _g.setClip(0, 0, CNGraphics.SCREEN_WIDTH, CNGraphics.SCREEN_HEIGHT);
        _g.setColor(40951);
        _g.fillRect(0, 0, CNGraphics.SCREEN_WIDTH, CNGraphics.SCREEN_HEIGHT);
        _g.setColor(10217215);
        _g.drawRect(x - 2, y - 2, w + 3, h + 3);
        _g.fillRect(x, y, this.m_iPrerunLoadPercent, h);
        _g.setColor(0xFFFFFF);
        _g.drawString("Loading...", 95, 115, 0);
    }

    protected void prerunLoad() {
        this.m_iState = 2;
    }

    public Core() {
        try {
            this.img = Image.createImage((String)"/HourGlass.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        me = this;
        this.m_graphics = new CNGraphics();
    }

    public void setMenuScripts(MenuScriptsRoot ms) {
        this.menuScripts = ms;
    }

    public void prime(CoreMidlet midlet) {
        this.random = new Random(System.currentTimeMillis());
        this.m_midlet = midlet;
        this.thread = null;
        this.m_isRunning = false;
        this.setFullScreenMode(true);
        this.thread = new Thread(this);
        this.resolveDevice();
        this.resolveScreenSize();
    }

    private void resolveDevice() {
        this.version = "V" + this.m_midlet.getAppProperty("MIDlet-Version");
        this.manufacturer = this.m_midlet.getAppProperty("MIDlet-Description");
        if (this.manufacturer == null) {
            this.manufacturer = "Unknown";
        }
    }

    protected void sizeChanged(int width, int height) {
        this.resolveScreenSize();
    }

    public void hideNotify() {
        this.m_bPaused = true;
        SchoolCore.snd_check = false;
        int pauseMenu = Menu.getPauseMenu();
        int gameMenu = Menu.m_iGameMenu;
        if (pauseMenu >= 0 && Menu.inMenu(gameMenu)) {
            Menu.gotoMenu(pauseMenu);
        }
    }

    protected void showNotify() {
        this.m_bPaused = false;
        SchoolCore.snd_check = true;
        if (Menu.iCurrentMenu == 14 || Menu.iCurrentMenu == 96 || Menu.iCurrentMenu == 88 || Menu.iCurrentMenu == 115 && SchoolCore.snd_check) {
            if (CNSound.isSoundEnabled()) {
                this.bgm1 = new CNSound("/SD_Theme_4.mid");
                this.bgm1.loop();
            }
            SchoolCore.snd_check = false;
        }
        this.resolveScreenSize();
    }

    private void resolveScreenSize() {
        this.setScreenSize(CNGraphics.SCREEN_WIDTH, CNGraphics.SCREEN_HEIGHT);
    }

    public void start() {
        this.thread.start();
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    protected void paint(Graphics graphics) {
        if (first) {
            graphics.setColor(0, 126, 196);
            graphics.fillRect(0, 0, 240, 320);
            graphics.drawImage(this.img, 120 - this.img.getWidth() / 2, 160 - this.img.getHeight() / 2, 0);
            first = false;
        }
        if (this.m_iState == 3) {
            this.renderError(graphics);
            return;
        }
        if (this.m_iState == 1) {
            this.prerunRender(graphics);
            return;
        }
        if (this.m_bInitialLoad) {
            graphics.setClip(0, 0, 240, 320);
            graphics.setColor(0);
            graphics.fillRect(0, 0, 240, 320);
            return;
        }
        if (!this.m_isRunning || this.m_bPaused || this.m_bPainting) {
            return;
        }
        this.m_bPainting = true;
        this.m_graphics.setGraphics(graphics);
        CNText.setGraphics(graphics);
        if (this.m_keyMask > 0) {
            this.onKeyHeld(this.m_keyMask);
        }
        Menu.renderCurrent(this.m_graphics);
        this.m_bPainting = false;
    }

    public void forceRepaint() {
    }

    public void run() {
        this.m_isRunning = true;
        while (this.m_isRunning) {
            if (this.m_iState == 2) {
                if (!this.m_bPaused && !this.m_bPainting) {
                    this.logicLoop();
                    this.repaint();
                    this.serviceRepaints();
                    continue;
                }
                try {
                    Core core = this;
                    core.thread.yield();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.m_iState == 3) {
                this.repaint();
                this.serviceRepaints();
                continue;
            }
            if (this.m_iState == 1) {
                this.prerunLoad();
                continue;
            }
            this.m_iState = 1;
        }
    }

    public void showSoftkeys() {
        this.m_bSoftsDisabled = false;
    }

    public void hideSoftkeys() {
        this.m_bSoftsDisabled = true;
    }

    private boolean validKey(int _key) {
        for (int i = 0; i <= 12; ++i) {
            if (_key != 1 << i) continue;
            return true;
        }
        return false;
    }

    protected void keyPressed(int keycode) {
        if (this.m_strError != null) {
            this.m_strError = null;
            this.m_iState = 0;
            return;
        }
        if (this.m_bInitialLoad) {
            return;
        }
        if (!Menu.allowInput()) {
            return;
        }
        if (this.m_bPaused) {
            return;
        }
        if (keycode - 48 >= 0 && keycode - 48 <= 9 && this.onNumberKey(keycode - 48)) {
            return;
        }
        keycode = keycode == -6 ? 32 : (keycode == -7 ? 64 : this.getDecentKeymapValue(keycode));
        this.keyDown(keycode);
        if (!this.m_bSoftsDisabled && Menu.currentMenu.onSoft(keycode)) {
            return;
        }
        if (this.onKeyDown(keycode)) {
            return;
        }
        switch (keycode) {
            case 1: {
                Menu.highlightPrev();
                break;
            }
            case 4: {
                Menu.highlightNext();
                break;
            }
        }
        Menu.currentMenu.onKeyPressed(keycode);
        this.afterKeyPressed(keycode);
    }

    protected void keyReleased(int keycode) {
        if (this.m_bInitialLoad) {
            return;
        }
        if (this.m_bPaused) {
            return;
        }
        keycode = this.getDecentKeymapValue(keycode);
        this.keyUp(keycode);
        if (this.onKeyUp(keycode)) {
            return;
        }
    }

    private void keyDown(int keycode) {
        this.m_keyMask |= keycode;
    }

    private void keyUp(int keycode) {
        this.m_keyMask &= ~keycode;
    }

    int getDecentKeymapValue(int keycode) {
        int gamekeycode = this.getGameAction(keycode);
        if (keycode == -6) {
            return 32;
        }
        if (keycode == -7) {
            return 64;
        }
        if (gamekeycode == 1) {
            return 1;
        }
        if (gamekeycode == 5) {
            return 2;
        }
        if (gamekeycode == 6) {
            return 4;
        }
        if (gamekeycode == 2) {
            return 8;
        }
        if (gamekeycode == 8) {
            return 16;
        }
        if (keycode == 49) {
            return 128;
        }
        if (keycode == 51) {
            return 256;
        }
        if (keycode == 55) {
            return 512;
        }
        if (keycode == 57) {
            return 1024;
        }
        if (keycode == 35) {
            return 2048;
        }
        if (keycode == 42) {
            return 4096;
        }
        return 0;
    }

    public void endCore() {
        me = null;
        this.m_midlet.endApp();
    }

    public abstract ScreenObject loadUniqueScreenObject(int var1, Stream var2) throws IOException;

    public void drawDownArrow(Graphics g, int x, int y, int size) {
        int growth = 0;
        for (int i = 0; i < size; ++i) {
            g.drawLine(x - growth, y, x + growth, y);
            --y;
            ++growth;
        }
    }

    public void drawUpArrow(Graphics g, int x, int y, int size) {
        int growth = 0;
        for (int i = 0; i < size; ++i) {
            g.drawLine(x - growth, y, x + growth, y);
            ++y;
            ++growth;
        }
    }

    private void renderError(Graphics graphics) {
        graphics.setClip(0, 0, 176, 220);
        graphics.setColor(1193046);
        graphics.fillRect(0, 0, 176, 220);
        graphics.setColor(11259375);
        for (int i = 0; i < this.m_strError.size(); ++i) {
            graphics.drawString((String)this.m_strError.elementAt(i), 10, 10 + i * 15, 0);
        }
    }

    static {
        first = true;
    }
}

