/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.gui;

import com.creativenorth.base.Core;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNMosaic;
import com.creativenorth.graphics.CNText;
import com.creativenorth.gui.Button;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.io.Stream;
import java.io.IOException;

public class List
extends Button {
    int m_type;
    int m_index;
    int[] m_list;
    int m_arrowMosaic;
    int m_fragmentLeftOn;
    int m_fragmentLeftOff;
    int m_fragmentRightOn;
    int m_fragmentRightOff;

    public List() {
        this.m_objectType = 4;
    }

    public static int getSelectedIndex(int _index) {
        return ((List)ScreenObject.allScreenObjects[_index]).getIndex();
    }

    public static void setSelectedIndex(int _index, int _val) {
        ((List)ScreenObject.allScreenObjects[_index]).setIndex(_val);
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int index) {
        this.m_index = index;
        if (this.m_index < 0 || this.m_index >= this.m_list.length) {
            return;
        }
        this.text = this.m_list[this.m_index];
        this.enableWrapBounce();
    }

    public int getSize() {
        return this.m_list.length;
    }

    public void load(Stream stream) throws IOException {
        this.m_type = stream.readU8();
        this.m_index = stream.readU8();
        this.m_list = new int[stream.readU8()];
        if (this.m_type == 2) {
            for (int i = 0; i < this.m_list.length; ++i) {
                this.m_list[i] = stream.readU24();
            }
        } else if (this.m_type == 0) {
            for (int i = 0; i < this.m_list.length; ++i) {
                this.m_list[i] = stream.readU16();
            }
        }
        if (this.m_index >= 0 && this.m_index < this.m_list.length) {
            this.text = this.m_list[this.m_index];
        }
        this.font = stream.readU8();
        this.m_arrowMosaic = stream.readS16();
        if (this.m_arrowMosaic >= 0) {
            this.m_fragmentLeftOff = stream.readU16();
            this.m_fragmentLeftOn = stream.readU16();
            this.m_fragmentRightOff = stream.readU16();
            this.m_fragmentRightOn = stream.readU16();
        }
        super.load(stream);
        this.textAlign = 2;
        this.setWrapBouncePadding(CNMosaic.mosaics[this.m_arrowMosaic].getWidth(this.m_fragmentRightOn) + 3);
    }

    public void select(int _dir) {
        if (this.m_list.length == 0) {
            return;
        }
        this.m_index += _dir;
        if (this.m_index > this.m_list.length - 1) {
            this.m_index = 0;
        }
        if (this.m_index < 0) {
            this.m_index = this.m_list.length - 1;
        }
        this.text = this.m_list[this.m_index];
        this.enableWrapBounce();
        Core.me.onListChange(this.id, this.m_index, _dir);
    }

    public void render(CNGraphics graphics) {
        if (!this.visible) {
            return;
        }
        CNText.setFont(this.font);
        if (this.m_type == 2) {
            graphics.setClip(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
            int dropletSize = this.boundsHeight - 2;
            int x = this.boundsX + (this.boundsWidth - this.m_list.length * dropletSize >> 1);
            int y = this.boundsY + 1;
            for (int i = 0; i < this.m_list.length; ++i) {
                graphics.setColor(this.m_list[i]);
                graphics.fillRect(x, y, dropletSize, dropletSize);
                if (i == this.m_index) {
                    graphics.setColor(0);
                    graphics.drawRect(x, y, dropletSize, dropletSize);
                    if (this.m_bSelected) {
                        graphics.setColor(0xFFFFFF);
                    } else {
                        graphics.setColor(0x888888);
                    }
                    graphics.drawRect(x + 1, y + 1, dropletSize - 2, dropletSize - 2);
                }
                x += dropletSize;
            }
        } else if (this.m_type == 0) {
            if (this.opaque) {
                graphics.setClip(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
                if (this.m_bSelected) {
                    graphics.setColor(this.selectedColor);
                } else {
                    graphics.setColor(this.color);
                }
                graphics.fillRect(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
            }
            if (this.m_index >= this.m_list.length) {
                return;
            }
            if (this.m_arrowMosaic >= 0) {
                CNMosaic.mosaics[this.m_arrowMosaic].draw(graphics.m_graphics, this.m_bSelected ? this.m_fragmentLeftOn : this.m_fragmentLeftOff, this.boundsX, this.boundsY);
                CNMosaic.mosaics[this.m_arrowMosaic].draw(graphics.m_graphics, this.m_bSelected ? this.m_fragmentRightOn : this.m_fragmentRightOff, this.boundsX + this.boundsWidth - CNMosaic.mosaics[this.m_arrowMosaic].getWidth(this.m_fragmentRightOn), this.boundsY);
                graphics.setClip(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
            }
            int x = this.boundsX + (this.boundsWidth - CNText.getWidth(CNText.getFullString(this.text)) >> 1);
            int y = this.boundsY;
            if (this.m_bWrapBounce) {
                if (this.m_bSelected) {
                    if (this.m_iBounceMax - this.m_iBounceMin > 0) {
                        long t = System.currentTimeMillis() / 100L % (long)(this.m_iBounceMax - this.m_iBounceMin << 1) + (long)this.m_iBounceMin;
                        x = (int)((long)x - (t < (long)this.m_iBounceMax ? t : (long)this.m_iBounceMax - (t - (long)this.m_iBounceMax)));
                    }
                } else {
                    x -= this.m_iBounceMin;
                }
            }
            int pad = CNMosaic.mosaics[this.m_arrowMosaic].getWidth(this.m_fragmentRightOn);
            graphics.setClip(this.boundsX + pad, this.boundsY, this.boundsWidth - (pad << 1), this.boundsHeight);
            CNText.drawString(this.text, x, y + 2);
        }
    }

    public static void setList(int _id, int[] _list, int _index, int _count) {
        if (ScreenObject.isInvalid(_id)) {
            return;
        }
        ((List)ScreenObject.allScreenObjects[_id]).m_list = new int[_count];
        System.arraycopy(_list, _index, ((List)ScreenObject.allScreenObjects[_id]).m_list, 0, _count);
    }
}

