/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.gui;

import com.creativenorth.base.Core;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.gui.Button;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.io.Stream;
import java.io.IOException;
import schoolfriends.SchoolCore;

public class Menu
extends ScreenObject {
    public static Menu currentMenu;
    public static int iCurrentMenu;
    private Button[] buttons;
    private int buttonCount;
    private Button buttonLSK;
    private Button buttonRSK;
    public static int m_iSelectedButton;
    public static int menuCount;
    public static int m_pauseMenuID;
    public static int m_iGameMenu;
    public static int m_iPrevMenu;
    private static int nextMenu;
    private static long nextMenuTime;
    private static int[] m_iaMenuDataFileOffsets;
    private static int[] m_iaMenuIDs;
    private static String m_strPath;

    public static final int getPreviousMenuID() {
        return m_iPrevMenu;
    }

    public static final Menu getPreviousMenu() {
        if (m_iPrevMenu < 0) {
            return null;
        }
        return (Menu)ScreenObject.allScreenObjects[m_iPrevMenu];
    }

    private static void loadMinimal(String _path) throws IOException {
        m_strPath = _path;
        Stream stream = new Stream(m_strPath);
        ScreenObject.screenObjectCount = stream.readU16();
        ScreenObject.allScreenObjects = new ScreenObject[ScreenObject.screenObjectCount];
        menuCount = stream.readU8();
        m_iaMenuDataFileOffsets = new int[menuCount];
        m_iaMenuIDs = new int[menuCount];
        for (int m = 0; m < menuCount; ++m) {
            int id;
            int offsetPosition;
            Menu.m_iaMenuDataFileOffsets[m] = offsetPosition = stream.readU16();
            Menu.m_iaMenuIDs[m] = id = stream.readU16();
        }
        if (stream != null) {
            stream.close();
            stream = null;
        }
    }

    public static void load(String path) {
        try {
            Menu.loadMinimal(path);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void flyLoad(int _menu) {
        try {
            Menu menu;
            Menu.clean();
            Stream stream = new Stream(m_strPath);
            int offset = 0;
            for (int m = 0; m < menuCount; ++m) {
                if (m_iaMenuIDs[m] != _menu) continue;
                offset = m_iaMenuDataFileOffsets[m] + 1;
                break;
            }
            stream.skip(offset);
            int temp = ScreenObject.screenObjectCount;
            ScreenObject.screenObjectCount = _menu;
            currentMenu = menu = new Menu();
            iCurrentMenu = _menu;
            menu.load(stream);
            if (stream != null) {
                stream.close();
                stream = null;
            }
            ScreenObject.screenObjectCount = temp;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void unload() {
        for (int i = 0; i < Core.me.menuScripts.image.length; ++i) {
            Core.me.menuScripts.image[i].unload();
        }
        currentMenu = null;
    }

    public static void gotoMenuTimed(int which) {
        nextMenu = which;
        nextMenuTime = System.currentTimeMillis() + 1500L;
    }

    public static final void gotoMenu(int _which, int _transition) {
        Menu.gotoMenu(_which);
    }

    public static void gotoMenu(int which) {
        try {
            Core.me.menuScripts.unloadAllImages();
            Menu.flyLoad(which);
            nextMenu = -1;
            m_iPrevMenu = iCurrentMenu;
            currentMenu = (Menu)ScreenObject.allScreenObjects[which];
            iCurrentMenu = which;
            currentMenu.highlight(0);
            Core.me.menuScripts.runAction(iCurrentMenu);
            Core.me.onMenuChange();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void clean() {
        for (int i = 0; i < ScreenObject.screenObjectCount; ++i) {
            ScreenObject.allScreenObjects[i] = null;
        }
        System.gc();
    }

    public static void renderCurrent(CNGraphics graphics) {
        if (nextMenu > -1 && nextMenuTime < System.currentTimeMillis()) {
            Menu.gotoMenu(nextMenu);
        }
        if (currentMenu != null) {
            currentMenu.render(graphics);
            if (SchoolCore.GMG && Menu.currentMenu.id == 10) {
                graphics.m_graphics.setClip(CNGraphics.SCREEN_WIDTH / 2 - SchoolCore.GMG_STATIC_IMAGE.getWidth() / 2, 0, SchoolCore.GMG_STATIC_IMAGE.getWidth(), CNGraphics.SCREEN_HEIGHT - 11);
                graphics.m_graphics.drawImage(SchoolCore.GMG_STATIC_IMAGE, CNGraphics.SCREEN_WIDTH / 2 - SchoolCore.GMG_STATIC_IMAGE.getWidth() / 2, (CNGraphics.SCREEN_HEIGHT - 11) / 2 - SchoolCore.GMG_STATIC_IMAGE.getHeight() / 2, 0);
            }
        }
    }

    public void changeButtonFont(int index, int fontNumber) {
        this.buttons[index].font = fontNumber;
    }

    public int buttonCount() {
        return this.buttons.length;
    }

    public void load(Stream stream) throws IOException {
        super.load(stream);
    }

    public void addButton(Button newButton) {
        Button[] temp = new Button[this.buttonCount + 1];
        System.arraycopy(this.buttons, 0, temp, 0, this.buttonCount);
        this.buttons = temp;
        temp = null;
        this.buttons[this.buttonCount] = newButton;
        ++this.buttonCount;
    }

    public void setButtons(Button[] newButtons) {
        this.buttons = newButtons;
        this.buttonCount = this.buttons.length;
    }

    public void setLSK(Button newLSK) {
        this.buttonLSK = newLSK;
    }

    public void setRSK(Button newRSK) {
        this.buttonRSK = newRSK;
    }

    public void highlight(int which) {
        if (this.buttonCount <= 0) {
            m_iSelectedButton = 0;
            return;
        }
        m_iSelectedButton = which;
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] == null) continue;
            this.buttons[i].lowlight();
        }
        this.buttons[m_iSelectedButton].highlight();
    }

    public static void highlightPrev() {
        try {
            if (--m_iSelectedButton < 0) {
                m_iSelectedButton = Menu.currentMenu.buttonCount - 1;
            }
            if (!Menu.currentMenu.buttons[Menu.m_iSelectedButton].visible || !Menu.currentMenu.buttons[Menu.m_iSelectedButton].isSelectable) {
                Menu.highlightPrev();
                return;
            }
            currentMenu.highlight(m_iSelectedButton);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void highlightNext() {
        try {
            if (++m_iSelectedButton >= Menu.currentMenu.buttonCount) {
                m_iSelectedButton = 0;
            }
            if (!Menu.currentMenu.buttons[Menu.m_iSelectedButton].visible || !Menu.currentMenu.buttons[Menu.m_iSelectedButton].isSelectable) {
                Menu.highlightNext();
                return;
            }
            currentMenu.highlight(m_iSelectedButton);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean onSoft(int key) {
        if (key == 32) {
            if (this.buttonLSK != null) {
                this.buttonLSK.select(0);
                return true;
            }
        } else if (key == 64 && this.buttonRSK != null) {
            this.buttonRSK.select(0);
            return true;
        }
        return false;
    }

    public boolean onKeyPressed(int key) {
        if (this.buttons == null || this.buttons.length <= 0) {
            return false;
        }
        if (key == 16) {
            if (this.buttons[m_iSelectedButton] != null) {
                this.buttons[m_iSelectedButton].select(0);
                return true;
            }
        } else if (key == 8) {
            if (this.buttons[m_iSelectedButton] != null) {
                this.buttons[m_iSelectedButton].select(-1);
                return true;
            }
        } else if (key == 2 && this.buttons[m_iSelectedButton] != null) {
            this.buttons[m_iSelectedButton].select(1);
            return true;
        }
        return false;
    }

    public static int getPauseMenu() {
        return m_pauseMenuID;
    }

    public static boolean inMenu(int menu) {
        return iCurrentMenu == menu;
    }

    public static boolean allowInput() {
        return currentMenu != null;
    }

    public Menu() {
        this.m_objectType = 1;
        this.buttonCount = 0;
        this.buttons = new Button[0];
    }

    static {
        iCurrentMenu = -1;
        m_iSelectedButton = 0;
        m_pauseMenuID = -1;
        m_iGameMenu = -1;
        m_iPrevMenu = -1;
        nextMenu = -1;
        nextMenuTime = 0L;
    }
}

