/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends;

import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class CNSound {
    public static boolean m_bSoundEnabled = true;
    private static Vector us = new Vector();
    private Player player;
    private VolumeControl volume;
    private String m_name;

    public CNSound(String name) {
        try {
            this.m_name = name;
            InputStream is = this.getClass().getResourceAsStream(this.m_name);
            this.player = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            us.addElement(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getVolumeControl(Player p) {
        Control[] c;
        if (p != null && (c = p.getControls()) != null && c.length > 0) {
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof VolumeControl)) continue;
                this.volume = (VolumeControl)c[i];
                break;
            }
        }
    }

    public void kill() {
        if (this.player != null) {
            try {
                this.player.stop();
                this.player.deallocate();
                this.player.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        us.removeElement(this);
    }

    public boolean play(int loopcount) {
        if (this.isPlaying()) {
            return false;
        }
        if (m_bSoundEnabled) {
            try {
                if (this.player != null) {
                    this.player.setLoopCount(1);
                    this.player.start();
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        return this.player.getState() == 400;
    }

    public boolean loop() {
        return this.play(-1);
    }

    public boolean play() {
        return this.play(1);
    }

    public void stop() {
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setVolume(int vol) {
        if (this.volume != null) {
            try {
                this.volume.setLevel(vol);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void fade(int start, int end, int step, int delay) {
        if (this.volume != null) {
            try {
                this.volume.setLevel(start);
                new Fader(this.volume, end, step, delay).start();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void fade(int start, int end, int step) {
        if (this.volume != null) {
            try {
                this.volume.setLevel(start);
                new Fader(this.volume, end, step).start();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void fadeTo(int end, int step, int delay) {
        if (this.volume != null) {
            new Fader(this.volume, end, step, delay).start();
        }
    }

    public void fadeTo(int end, int step) {
        if (this.volume != null) {
            new Fader(this.volume, end, step).start();
        }
    }

    public static void stopall() {
        for (int i = 0; i < us.size(); ++i) {
            ((CNSound)us.elementAt(i)).stop();
        }
    }

    public static void killall() {
        for (int i = 0; i < us.size(); ++i) {
            ((CNSound)us.elementAt(i)).kill();
        }
    }

    public static boolean isSoundEnabled() {
        return m_bSoundEnabled;
    }

    public static boolean setSoundEnabled(boolean enabled) {
        m_bSoundEnabled = enabled;
        if (!m_bSoundEnabled) {
            CNSound.stopall();
            CNSound.killall();
        }
        return m_bSoundEnabled;
    }

    public static final boolean toggleSoundEnabled() {
        return CNSound.setSoundEnabled(!m_bSoundEnabled);
    }

    private class Fader
    extends Thread {
        VolumeControl v;
        int end;
        int step;
        int delay;

        public Fader(VolumeControl v, int end, int step, int delay) {
            this.v = v;
            this.end = end;
            this.step = step;
            this.delay = delay;
        }

        public Fader(VolumeControl v, int end, int step) {
            this.v = v;
            this.end = end;
            this.step = step;
            this.delay = 0;
        }

        public void run() {
            while (this.v != null) {
                int level = this.v.getLevel();
                if (level >= this.end - this.step && level <= this.end + this.step) {
                    this.v.setLevel(this.end);
                    return;
                }
                if (level < this.end - this.step) {
                    level += this.step;
                } else if (level > this.end + this.step) {
                    level -= this.step;
                }
                if (this.delay <= 0) continue;
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }
}

