/*
 * Decompiled with CFR 0.152.
 */
package com.creativenorth.gui;

import com.creativenorth.base.Core;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNText;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.io.Stream;
import java.io.IOException;

public class Button
extends ScreenObject {
    public static int MAXIMUM_EDIT_CHARACTERS = 12;
    private int m_action;
    public int m_trigger;
    private boolean m_bEdit = false;
    private String m_editText;
    private long moveOnTime;
    int m_iPresses = 0;
    int m_iKey = 0;
    char m_iChar = '\u0000';
    final char[] chars = new char[]{' ', '\u0000', '\u0000', '\u0000', '.', ',', '@', '\u0000', 'a', 'b', 'c', '\u0000', 'd', 'e', 'f', '\u0000', 'g', 'h', 'i', '\u0000', 'j', 'k', 'l', '\u0000', 'm', 'n', 'o', '\u0000', 'p', 'q', 'r', 's', 't', 'u', 'v', '\u0000', 'w', 'x', 'y', 'z'};

    public Button() {
        this.m_objectType = 2;
    }

    public void load(Stream stream) throws IOException {
        this.m_action = stream.readU16();
        this.m_trigger = stream.readU8();
        super.load(stream);
    }

    public void select(int dir) {
        if (dir == 0) {
            Core.me.menuScripts.runAction(this.m_action);
        }
    }

    public void render(CNGraphics graphics) {
        if (!this.m_bEdit) {
            super.render(graphics);
            return;
        }
        graphics.setClip(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
        graphics.setColor(this.selectedColor);
        graphics.fillRect(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
        CNText.setFont(this.font);
        int newX = this.imageX + 4;
        String str = this.getEditText();
        CNText.drawString(str, newX, this.imageY);
        int cx = newX + CNText.getWidth(str);
        graphics.setClip(this.boundsX, this.boundsY, this.boundsWidth, this.boundsHeight);
        graphics.setColor(0);
        graphics.drawLine(cx, this.imageY + 2, cx, this.imageY + 2 + 8);
        graphics.drawLine(++cx, this.imageY + 2, cx, this.imageY + 2 + 8);
    }

    public String getEditText() {
        if (this.m_iChar == '\u0000') {
            return this.m_editText;
        }
        return this.m_editText + this.m_iChar;
    }

    public static void editOn(int _index) {
        ((Button)ScreenObject.allScreenObjects[_index]).editOn();
    }

    public void editOn() {
        this.m_bEdit = true;
        this.m_editText = CNText.getFullString(this.text).trim();
    }

    public static String editOff(int _index) {
        return ((Button)ScreenObject.allScreenObjects[_index]).editOff();
    }

    public String editOff() {
        this.m_bEdit = false;
        return this.m_editText;
    }

    public static boolean onEditKey(int _index, int keymask) {
        return ((Button)ScreenObject.allScreenObjects[_index]).onEditKey(keymask);
    }

    public boolean onEditKey(int keymask) {
        switch (keymask) {
            case 2: 
            case 4: 
            case 16: 
            case 2048: {
                if (this.m_iChar != '\u0000') {
                    this.append(this.m_iChar);
                    this.m_iKey = 0;
                    this.m_iPresses = 0;
                    this.m_iChar = '\u0000';
                }
                return true;
            }
            case 1: 
            case 8: 
            case 4096: {
                this.backspace();
                return true;
            }
        }
        return false;
    }

    public static boolean onEditNumber(int _index, int _num) {
        return ((Button)ScreenObject.allScreenObjects[_index]).onEditNumber(_num);
    }

    public boolean onEditNumber(int _num) {
        if (this.m_iKey < 0 && this.m_iKey > 9 || this.m_editText.length() >= MAXIMUM_EDIT_CHARACTERS) {
            return false;
        }
        if (this.m_iKey == _num) {
            ++this.m_iPresses;
        } else {
            if (this.m_iChar != '\u0000') {
                this.append(this.m_iChar);
            }
            this.m_iKey = _num;
            this.m_iPresses = 0;
        }
        if (this.m_iKey >= 0 && this.m_iKey <= 9 && this.m_editText.length() < MAXIMUM_EDIT_CHARACTERS) {
            this.m_iChar = this.chars[this.m_iKey * 4 + this.m_iPresses % 4];
            while (this.m_iChar == '\u0000') {
                this.m_iChar = this.chars[this.m_iKey * 4 + this.m_iPresses++ % 4];
            }
            if (this.m_editText.length() == 0 && this.m_iKey >= 2) {
                this.m_iChar = (char)(this.m_iChar - 32);
            }
        } else {
            this.m_iChar = '\u0000';
            this.m_iKey = 0;
            this.m_iPresses = 0;
        }
        return true;
    }

    public void append(char _c) {
        this.m_editText = this.m_editText + _c;
    }

    public void backspace() {
        if (this.m_iChar != '\u0000') {
            this.m_iChar = '\u0000';
            return;
        }
        if (this.m_editText.length() > 0) {
            this.m_editText = this.m_editText.substring(0, this.m_editText.length() - 1);
        }
    }
}

