/*
 * Decompiled with CFR 0.152.
 */
package schoolfriends;

import com.creativenorth.dev.Log;
import com.creativenorth.graphics.CNGraphics;
import com.creativenorth.graphics.CNText;
import com.creativenorth.gui.ScreenObject;
import com.creativenorth.io.Stream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import schoolfriends.Data;
import schoolfriends.graphics.Engine;
import schoolfriends.loading.CNSaveData;

public class FriendList
extends ScreenObject
implements CNSaveData.Storable {
    public static FriendList me;
    final int MAX_FRIENDS;
    int friendCount = 0;
    int[] m_friends = new int[50];
    int highlightedFriend = 0;
    int topFriend = 0;
    final int BAR_HEIGHT;
    final int SEPARATOR_THICKNESS;
    final int TEXT_DROP;
    final int SCROLLBAR_WIDTH;
    final int SHIFT_BOUNDRY;
    int ROW_COUNT;
    private int m_iHighlightedPopupIndex;
    private boolean m_bPopupVisible;
    final int POPUP_WIDTH;
    final int POPUP_ROW_HEIGHT;
    String m_strLocation;

    public FriendList() {
        this.MAX_FRIENDS = 50;
        this.BAR_HEIGHT = 20;
        this.SEPARATOR_THICKNESS = 2;
        this.TEXT_DROP = 4;
        this.SCROLLBAR_WIDTH = 11;
        this.SHIFT_BOUNDRY = 2;
        this.POPUP_WIDTH = 120;
        this.POPUP_ROW_HEIGHT = 16;
        this.visible = false;
        me = this;
    }

    public void load(Stream _stream) throws IOException {
        super.load(_stream);
        this.ROW_COUNT = this.boundsHeight / 20;
        this.enableScrollBar(11, 3, 10217215, 40951, 10217215);
    }

    private void shiftHighlight(int _dir) {
        this.highlightedFriend += _dir;
        if (this.highlightedFriend < 0) {
            this.highlightedFriend = 0;
        }
        if (this.highlightedFriend > this.friendCount - 1) {
            this.highlightedFriend = this.friendCount - 1;
        }
        if (this.highlightedFriend - this.topFriend > this.ROW_COUNT - 2 - 1 && this.topFriend < this.friendCount - this.ROW_COUNT) {
            this.topFriend += _dir;
        }
        if (this.highlightedFriend - this.topFriend < 2 && this.topFriend > 0) {
            --this.topFriend;
        }
        if (this.m_bScrollNeeded) {
            this.setScrollBarPosition(this.topFriend * 20);
        }
    }

    public void addFriend(int _friendID) {
        int i = this.friendCount;
        while (i-- > 0) {
            if (this.m_friends[i] != _friendID) continue;
            return;
        }
        this.m_friends[this.friendCount++] = _friendID;
        this.setScrollBarMaximum(20 * this.friendCount, this.boundsHeight - this.boundsHeight % 20);
        this.shiftHighlight(0);
    }

    public boolean onKeyDown(int keymask) {
        if (!this.visible) {
            return false;
        }
        if (this.m_bPopupVisible) {
            if ((keymask & 0x10) == 16) {
                if (this.m_strLocation != null) {
                    this.m_strLocation = null;
                } else if (this.m_iHighlightedPopupIndex == 0) {
                    this.call(this.m_friends[this.highlightedFriend - this.topFriend]);
                } else if (this.m_iHighlightedPopupIndex == 1) {
                    this.hidePopup();
                }
            } else if ((keymask & 4) == 4) {
                this.shiftPopupHighlight(1);
            } else if ((keymask & 1) == 1) {
                this.shiftPopupHighlight(-1);
            }
            return true;
        }
        if ((keymask & 0x10) == 16) {
            this.showPopup();
            return true;
        }
        if ((keymask & 4) == 4) {
            this.shiftHighlight(1);
            return true;
        }
        if ((keymask & 1) == 1) {
            this.shiftHighlight(-1);
            return true;
        }
        return false;
    }

    public void render(CNGraphics graphics) {
        int i;
        if (!this.visible) {
            return;
        }
        int x = this.boundsX;
        int y = this.boundsY;
        int w = this.boundsWidth;
        int h = this.boundsHeight;
        int r = x + w;
        int b = y + h;
        graphics.setClip(x, y, w, h);
        graphics.setColor(this.color);
        graphics.fillRect(x, y, w, h);
        for (i = this.topFriend; i < this.friendCount && i < this.topFriend + this.ROW_COUNT; ++i) {
            graphics.setClip(x, y, w, h);
            graphics.setColor(7983099);
            graphics.fillRect(x, y, w, 20);
            graphics.setColor(10217215);
            graphics.fillRect(x + 2, y + 20 - 2, w - 4, 2);
            if (i == this.highlightedFriend) {
                graphics.setColor(16742656);
                graphics.fillRect(x + 2, y, w - 4, 18);
            }
            y += 20;
        }
        y = this.boundsY;
        CNText.setFont(0);
        for (i = this.topFriend; i < this.friendCount && i < this.topFriend + this.ROW_COUNT; ++i) {
            try {
                graphics.setClip(x, y, w, h);
                CNText.drawString(Data.getCharacter((int)this.m_friends[i]).ingamename, x + 6, y + 4);
            }
            catch (Exception e) {
                Log.addExeption("Error rendering friendlist... ", e);
            }
            y += 20;
        }
        if (this.m_bScrollNeeded) {
            this.renderVerticalScrollBar(graphics.m_graphics, r, this.boundsY, h);
        }
        this.renderPopup(graphics.m_graphics, this.boundsX + 30, this.boundsY + 8 + 20 * (this.highlightedFriend - this.topFriend), Data.getCharacter(this.m_friends[this.highlightedFriend]));
    }

    private void renderPopup(Graphics _graphics, int _x, int _y, Data.MasterCharacter _mc) {
        if (!this.m_bPopupVisible) {
            return;
        }
        _graphics.setClip(_x - 1, _y - 1, 122, 50);
        _graphics.setColor(0);
        _graphics.drawRect(_x - 1, _y - 1, 121, 49);
        _graphics.setColor(7983099);
        _graphics.fillRect(_x, _y, 120, 16);
        CNText.drawString(_mc.ingamename, _x + 6, _y + 2);
        _y += 16;
        if (this.m_iHighlightedPopupIndex == 0) {
            _graphics.setColor(16742656);
        } else {
            _graphics.setColor(40951);
        }
        _graphics.setClip(_x, _y, 120, 16);
        _graphics.fillRect(_x, _y, 120, 16);
        CNText.drawString("Where are you?", _x + 6, _y + 2);
        _y += 16;
        if (this.m_iHighlightedPopupIndex == 1) {
            _graphics.setColor(16742656);
        } else {
            _graphics.setColor(40951);
        }
        _graphics.setClip(_x, _y, 120, 16);
        _graphics.fillRect(_x, _y, 120, 16);
        CNText.drawString("Close", _x + 6, _y + 2);
        if (this.m_strLocation != null) {
            _graphics.setColor(7983099);
            _graphics.setClip(_x + 6, _y -= 8, 120, 16);
            _graphics.fillRect(_x + 6, _y, 120, 16);
            CNText.drawString(this.m_strLocation, _x + 12, _y + 2);
        }
    }

    private void shiftPopupHighlight(int _dir) {
        this.m_iHighlightedPopupIndex += _dir;
        if (this.m_iHighlightedPopupIndex < 0) {
            this.m_iHighlightedPopupIndex = 0;
        }
        if (this.m_iHighlightedPopupIndex > 1) {
            this.m_iHighlightedPopupIndex = 1;
        }
        this.m_strLocation = null;
    }

    private final void showPopup() {
        this.m_bPopupVisible = true;
        this.m_iHighlightedPopupIndex = 0;
    }

    private final void hidePopup() {
        this.m_bPopupVisible = false;
        this.m_strLocation = null;
    }

    public void call(int _mchr) {
        int room = Engine.FindCharacter(_mchr);
        this.m_strLocation = room != -1 ? "I'm in " + CNText.getFullString(Data.roomnames[room]) : "I'm Hiding";
    }

    public void save(CNSaveData _rms) {
        _rms.writeArrayU16(this.m_friends);
    }

    public void load(CNSaveData _rms) throws IOException {
        int i;
        this.m_friends = _rms.readArrayU16();
        for (i = 0; i < this.m_friends.length && this.m_friends[i] > 0; ++i) {
        }
        this.friendCount = i;
    }

    public void clean() {
        this.m_friends = new int[50];
        this.friendCount = 0;
        this.highlightedFriend = 0;
        this.topFriend = 0;
    }
}

