/*
 * Decompiled with CFR 0.152.
 */
package fi.tamk.tiko.gameprogramming.Slumber.ui;

import fi.tamk.tiko.gameprogramming.Slumber.ui.Slumber;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class MainMenu
extends GameCanvas {
    private Graphics g = this.getGraphics();
    private int halfWidth = this.getWidth() / 2;
    private Slumber game;
    private Image tausta;
    private Sprite village;
    private Sprite adventure;
    private Sprite story;
    private LayerManager layerManager;

    protected MainMenu(boolean suppressKeyEvents, Slumber game) {
        super(suppressKeyEvents);
        this.initSprites();
        try {
            this.tausta = Image.createImage((String)"/castlesilhouette.png");
        }
        catch (Exception e) {
            System.out.println("Can't read");
        }
        this.game = game;
        this.paintObjects(this.g);
    }

    protected void initSprites() {
        try {
            this.village = new Sprite(Image.createImage((String)"/Village_button.png"), 101, 43);
        }
        catch (Exception e) {
            System.out.println("Problem loading village button");
        }
        try {
            this.adventure = new Sprite(Image.createImage((String)"/Adventure_button.png"), 101, 43);
        }
        catch (Exception e) {
            System.out.println("Problem loading adventure button");
        }
        try {
            this.story = new Sprite(Image.createImage((String)"/Storie_button.png"), 101, 43);
        }
        catch (Exception e) {
            System.out.println("Problem loading storie button");
        }
        this.adventure.setPosition(180, 120);
        this.adventure.setVisible(true);
        this.adventure.setFrame(0);
        this.village.setPosition(40, 120);
        this.village.setVisible(true);
        this.village.setFrame(0);
        this.story.setPosition(this.getWidth() / 2 - 50, 180);
        this.story.setVisible(true);
        this.story.setFrame(0);
        this.layerManager = new LayerManager();
        this.layerManager.append((Layer)this.adventure);
        this.layerManager.append((Layer)this.village);
        this.layerManager.append((Layer)this.story);
    }

    protected void paintObjects(Graphics g) {
        g.setColor(62, 60, 63);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.tausta, this.halfWidth, 0, 17);
        this.layerManager.paint(g, 0, 0);
        this.flushGraphics();
    }

    public void pointerPressed(int x, int y) {
        if (y > 120 && y < 163 && x > 40 && x < 141) {
            this.village.nextFrame();
            this.paintAgain();
        }
        if (y > 120 && y < 163 && x > 180 && x < 281) {
            this.adventure.nextFrame();
            this.paintAgain();
        }
        if (y > 180 && y < 223 && x > this.halfWidth - 50 && x < this.halfWidth + 51) {
            this.story.nextFrame();
            this.paintAgain();
        }
    }

    public void pointerReleased(int x, int y) {
        if (y > 120 && y < 163 && x > 40 && x < 141) {
            this.village.setFrame(0);
            this.game.changeScreen(2);
            this.paintAgain();
        }
        if (y > 120 && y < 163 && x > 180 && x < 281) {
            this.adventure.setFrame(0);
            this.game.changeScreen(3);
            this.paintAgain();
        }
        if (y > 180 && y < 223 && x > this.halfWidth - 50 && x < this.halfWidth + 51) {
            this.story.setFrame(0);
            this.game.changeScreen(5);
            this.paintAgain();
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void paintAgain() {
        this.paintObjects(this.g);
    }
}

