/*
 * Decompiled with CFR 0.152.
 */
package fi.tamk.tiko.gameprogramming.Slumber.ui;

import fi.tamk.tiko.gameprogramming.Slumber.ui.Slumber;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class LogoScreen
extends GameCanvas
implements Runnable {
    private Graphics g = this.getGraphics();
    private int width = this.getWidth() / 2;
    private Slumber game;
    private Image tausta;
    private Sprite help;
    private Sprite about;
    private Sprite slumberLogo;
    private LayerManager layerManager;
    private int aboutCounter = 6;
    private int helpCounter = 6;
    private boolean goToHelp = false;
    private boolean goToAbout = false;
    private boolean logoRunning;
    private Thread thread;

    protected LogoScreen(boolean suppressKeyEvents, Slumber game) {
        super(suppressKeyEvents);
        this.initializeGraphics();
        this.thread = new Thread(this);
        this.thread.start();
        this.game = game;
        this.paintObjects(this.g);
        this.logoRunning = true;
    }

    private void initializeGraphics() {
        try {
            this.tausta = Image.createImage((String)"/castlesilhouette.png");
        }
        catch (Exception e) {
            System.out.println("Can't read background");
        }
        try {
            this.help = new Sprite(Image.createImage((String)"/helpbutton.png"), 54, 50);
        }
        catch (Exception e) {
            System.out.println("Can't read helpbutton");
        }
        try {
            this.about = new Sprite(Image.createImage((String)"/infobutton.png"), 54, 50);
        }
        catch (Exception e) {
            System.out.println("Can't read infobutton");
        }
        try {
            this.slumberLogo = new Sprite(Image.createImage((String)"/slumberlogo.png"), 199, 69);
        }
        catch (Exception e) {
            System.out.println("Can't read slumber logo");
        }
        this.layerManager = new LayerManager();
        this.help.setPosition(0, this.getHeight() - this.help.getHeight());
        this.about.setPosition(this.getWidth() - this.about.getWidth(), this.getHeight() - this.about.getHeight());
        this.slumberLogo.setPosition(60, 150);
        this.help.setFrame(5);
        this.about.setFrame(5);
        this.layerManager.append((Layer)this.help);
        this.layerManager.append((Layer)this.about);
        this.layerManager.append((Layer)this.slumberLogo);
    }

    protected void paintObjects(Graphics g) {
        g.setColor(62, 60, 63);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.tausta, this.width, 0, 17);
        this.layerManager.paint(g, 0, 0);
        this.flushGraphics();
    }

    public void pointerPressed(int x, int y) {
        if (x > 60 && x < 60 + this.slumberLogo.getWidth() && y > 150 && y < 150 + this.slumberLogo.getHeight() + 10) {
            this.game.changeScreen(10);
            this.logoRunning = false;
        }
        if (x < this.help.getWidth() && y > this.getHeight() - this.help.getHeight()) {
            this.goToHelp = true;
        }
        if (x > this.getWidth() - this.about.getWidth() && y > this.getHeight() - this.about.getHeight()) {
            this.goToAbout = true;
        }
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void paintAgain() {
        this.paintObjects(this.g);
    }

    public void run() {
        this.logoRunning = true;
        int reflectionCounter = 0;
        int counter = 0;
        int initButtons = 5;
        while (this.logoRunning) {
            if (initButtons > 0) {
                this.help.setFrame(initButtons);
                this.about.setFrame(initButtons);
                this.paintAgain();
                --initButtons;
            }
            if (this.goToHelp && this.helpCounter > 0) {
                this.help.nextFrame();
                --this.helpCounter;
                this.paintAgain();
            }
            if (this.goToAbout && this.aboutCounter > 0) {
                this.about.nextFrame();
                --this.aboutCounter;
                this.paintAgain();
            }
            if (this.aboutCounter == 0) {
                this.game.changeScreen(8);
                this.goToAbout = false;
                this.about.nextFrame();
                this.logoRunning = false;
            }
            if (this.helpCounter == 0) {
                this.game.changeScreen(9);
                this.goToHelp = false;
                this.about.nextFrame();
                this.logoRunning = false;
            }
            if (reflectionCounter == 7) {
                if (counter < 6) {
                    this.slumberLogo.nextFrame();
                    this.paintAgain();
                    ++counter;
                } else {
                    reflectionCounter = 0;
                    counter = 0;
                }
            } else {
                ++reflectionCounter;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                System.out.println("Sleeping problem");
            }
        }
    }
}

