/*
 * Decompiled with CFR 0.152.
 */
import Actions.CActExtension;
import Conditions.CCndExtension;
import Expressions.CValue;
import Extensions.CRunExtension;
import Objects.CObject;
import RunLoop.CCreateObjectInfo;
import Services.CBinaryFile;
import Services.CFontInfo;
import Services.CRect;
import Sprites.CMask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CRunPlatform
extends CRunExtension {
    int ObjFixed;
    int ObjShortCut;
    PlatformCOL Col;
    PlatformMove PFMove;
    PlatformActs actions = new PlatformActs(this);
    PlatformCnds conditions = new PlatformCnds(this);
    PlatformExpr expressions = new PlatformExpr(this);

    public int getNumberOfConditions() {
        return 7;
    }

    private String fixString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= '\n') continue;
            return string.substring(0, i);
        }
        return string;
    }

    public boolean createRunObject(CBinaryFile cBinaryFile, CCreateObjectInfo cCreateObjectInfo, int n) {
        cBinaryFile.setUnicode(false);
        cBinaryFile.skipBytes(8);
        this.PFMove = new PlatformMove();
        try {
            this.PFMove.MaxXVelocity = Integer.parseInt(this.fixString(cBinaryFile.readString(16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.PFMove.MaxYVelocity = Integer.parseInt(this.fixString(cBinaryFile.readString(16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.PFMove.XAccel = Integer.parseInt(this.fixString(cBinaryFile.readString(16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.PFMove.XDecel = Integer.parseInt(this.fixString(cBinaryFile.readString(16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.PFMove.Gravity = Integer.parseInt(this.fixString(cBinaryFile.readString(16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.PFMove.JumpStrength = Integer.parseInt(this.fixString(cBinaryFile.readString(16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.PFMove.JumpHoldHeight = Integer.parseInt(this.fixString(cBinaryFile.readString(16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.PFMove.StepUp = Integer.parseInt(this.fixString(cBinaryFile.readString(16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.PFMove.SlopeCorrection = Integer.parseInt(this.fixString(cBinaryFile.readString(16)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.Col = new PlatformCOL();
        this.Col.JumpThroughColTop = cBinaryFile.readByte() == 1;
        this.Col.EnableJumpThrough = cBinaryFile.readByte() == 1;
        return true;
    }

    public void destroyRunObject(boolean bl) {
    }

    private CObject GetCObject(int n) {
        CObject[] cObjectArray = this.rh.rhObjectList;
        for (int i = 0; i < cObjectArray.length; ++i) {
            if (cObjectArray[i] == null || (cObjectArray[i].hoCreationId << 16) + cObjectArray[i].hoNumber != n) continue;
            return cObjectArray[i];
        }
        return null;
    }

    private boolean IsOverObstacle() {
        this.Col.Obstacle = false;
        this.ho.generateEvent(0, this.ho.getEventParam());
        return this.Col.Obstacle;
    }

    private boolean IsOverJumpThrough() {
        if (!this.Col.EnableJumpThrough) {
            return false;
        }
        this.Col.JumpThrough = false;
        this.ho.generateEvent(1, this.ho.getEventParam());
        return this.Col.JumpThrough;
    }

    public int handleRunObject() {
        CObject cObject = this.GetCObject(this.ObjFixed);
        if (!this.PFMove.Paused && cObject != null) {
            int n;
            if (this.PFMove.RightKey && !this.PFMove.LeftKey) {
                this.PFMove.XVelocity += this.PFMove.XAccel;
            }
            if (this.PFMove.LeftKey && !this.PFMove.RightKey) {
                this.PFMove.XVelocity -= this.PFMove.XAccel;
            }
            if (this.PFMove.XVelocity != 0 && (!this.PFMove.LeftKey && !this.PFMove.RightKey || this.PFMove.LeftKey && this.PFMove.RightKey)) {
                this.PFMove.XVelocity -= this.PFMove.XVelocity / Math.abs(this.PFMove.XVelocity) * this.PFMove.XDecel;
                if (this.PFMove.XVelocity <= this.PFMove.XDecel && this.PFMove.XVelocity >= 0 - this.PFMove.XDecel) {
                    this.PFMove.XVelocity = 0;
                }
            }
            this.PFMove.XVelocity = Math.min(Math.max(this.PFMove.XVelocity, 0 - this.PFMove.MaxXVelocity), this.PFMove.MaxXVelocity);
            this.PFMove.YVelocity = Math.min(Math.max(this.PFMove.YVelocity + this.PFMove.Gravity, 0 - this.PFMove.MaxYVelocity), this.PFMove.MaxYVelocity);
            int n2 = this.PFMove.XVelocity + this.PFMove.AddXVelocity;
            int n3 = this.PFMove.YVelocity + this.PFMove.AddYVelocity;
            this.PFMove.XMoveCount += Math.abs(n2);
            this.PFMove.YMoveCount += Math.abs(n3);
            while (this.PFMove.XMoveCount > 100) {
                if (!this.IsOverObstacle()) {
                    cObject.hoX += n2 / Math.abs(n2);
                }
                if (this.IsOverObstacle()) {
                    for (n = 0; n < this.PFMove.StepUp; ++n) {
                        --cObject.hoY;
                        if (!this.IsOverObstacle()) break;
                    }
                    if (this.IsOverObstacle()) {
                        cObject.hoY += (short)this.PFMove.StepUp;
                        cObject.hoX -= n2 / Math.abs(n2);
                        this.PFMove.XMoveCount = 0;
                        this.PFMove.XVelocity = 0;
                    }
                }
                this.PFMove.XMoveCount -= 100;
                cObject.roc.rcChanged = true;
            }
            while (this.PFMove.YMoveCount > 100) {
                if (!this.IsOverObstacle()) {
                    cObject.hoY += n3 / Math.abs(n3);
                    this.PFMove.OnGround = false;
                }
                if (this.IsOverObstacle()) {
                    cObject.hoY -= n3 / Math.abs(n3);
                    if (n3 > 0) {
                        this.PFMove.OnGround = true;
                    }
                    this.PFMove.YMoveCount = 0;
                    this.PFMove.YVelocity = 0;
                }
                if (this.IsOverJumpThrough() && n3 > 0) {
                    if (this.Col.JumpThroughColTop) {
                        --cObject.hoY;
                        if (!this.IsOverJumpThrough()) {
                            cObject.hoY -= n3 / Math.abs(n3);
                            this.PFMove.YMoveCount = 0;
                            this.PFMove.YVelocity = 0;
                            this.PFMove.OnGround = true;
                        }
                        ++cObject.hoY;
                    } else {
                        cObject.hoY -= n3 / Math.abs(n3);
                        this.PFMove.YMoveCount = 0;
                        this.PFMove.YVelocity = 0;
                        this.PFMove.OnGround = true;
                    }
                }
                this.PFMove.YMoveCount -= 100;
                cObject.roc.rcChanged = true;
            }
            if (this.PFMove.SlopeCorrection > 0 && n3 >= 0) {
                n = 0;
                for (int i = 0; i < this.PFMove.SlopeCorrection; ++i) {
                    ++cObject.hoY;
                    if (!this.IsOverObstacle()) continue;
                    --cObject.hoY;
                    this.PFMove.OnGround = true;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    cObject.hoY -= (short)this.PFMove.SlopeCorrection;
                }
            }
        }
        this.PFMove.RightKey = false;
        this.PFMove.LeftKey = false;
        return 0;
    }

    public void displayRunObject(Graphics graphics) {
    }

    public void pauseRunObject() {
    }

    public void continueRunObject() {
    }

    public void saveBackground(Image image) {
    }

    public void restoreBackground(Graphics graphics) {
    }

    public void killBackground() {
    }

    public CFontInfo getRunObjectFont() {
        return null;
    }

    public void setRunObjectFont(CFontInfo cFontInfo, CRect cRect) {
    }

    public int getRunObjectTextColor() {
        return 0;
    }

    public void setRunObjectTextColor(int n) {
    }

    public CMask getRunObjectCollisionMask(int n) {
        return null;
    }

    public Image getRunObjectSurface() {
        return null;
    }

    public void getZoneInfos() {
    }

    public boolean condition(int n, CCndExtension cCndExtension) {
        return this.conditions.get(n, cCndExtension);
    }

    public void action(int n, CActExtension cActExtension) {
        this.actions.action(n, cActExtension);
    }

    public CValue expression(int n) {
        return this.expressions.get(n);
    }
}

