/*
 * Decompiled with CFR 0.152.
 */
package bluegammon;

import bluegammon.Resources;
import bluegammon.RmsFacade;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class Audio {
    public static final int MUSIC = 0;
    public static final int DICES_LONG = 1;
    public static final int DICES_SHORT = 2;
    public static final int PIECE = 3;
    public static final int MESSAGE = 4;
    public static final int CONN_FAIL = 5;
    public static final int WINNER = 6;
    public static final int LOSER = 7;
    protected static Player[] m_sounds = new Player[8];
    protected static int m_currentPlayer = -1;
    protected static final String TYPE_AMR = "audio/amr";
    protected static final String TYPE_MIDI = "audio/midi";

    public static synchronized void playSound(int n) {
        if (!RmsFacade.getBoolean(5)) {
            Player player;
            if (m_sounds[n] == null) {
                Audio.createSound(n);
            }
            if ((player = m_sounds[n]) != null) {
                try {
                    player.start();
                    m_currentPlayer = n;
                }
                catch (MediaException mediaException) {
                    mediaException.printStackTrace();
                }
            }
        }
    }

    public static synchronized void stopSound(int n) {
        if (m_sounds[n] != null) {
            try {
                m_sounds[n].stop();
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
            }
        }
    }

    public static void shutdown() {
        for (int i = 0; i < m_sounds.length; ++i) {
            Audio.stopSound(i);
            if (m_sounds[i] == null) continue;
            m_sounds[i].deallocate();
        }
    }

    protected static void createSound(int n) {
        try {
            int n2 = 0;
            String string = TYPE_AMR;
            switch (n) {
                case 0: {
                    string = TYPE_MIDI;
                    n2 = 203;
                    break;
                }
                case 4: {
                    string = TYPE_MIDI;
                    n2 = 204;
                    break;
                }
                case 5: {
                    string = TYPE_MIDI;
                    n2 = 205;
                    break;
                }
                case 6: {
                    string = TYPE_MIDI;
                    n2 = 206;
                    break;
                }
                case 7: {
                    string = TYPE_MIDI;
                    n2 = 207;
                    break;
                }
                case 1: {
                    n2 = 201;
                    break;
                }
                case 2: {
                    n2 = 200;
                    break;
                }
                case 3: {
                    n2 = 202;
                }
            }
            Audio.m_sounds[n] = Manager.createPlayer((InputStream)Resources.getResource(n2), (String)string);
            if (n == 0) {
                m_sounds[n].setLoopCount(-1);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    private Audio() {
    }
}

