/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui;

import bluegammon.Bluegammon;
import bluegammon.Resources;
import bluegammon.gui.BluetoothDevicePage;
import bluegammon.gui.menu.ItemAction;
import bluegammon.gui.menu.MenuPage;
import bluegammon.gui.menu.PageItem;
import bluegammon.gui.popup.Popup;
import bluegammon.gui.popup.PopupListener;
import bluegammon.io.BackgammonBTConnection;
import bluegammon.io.BackgammonConnection;
import java.io.IOException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;

public class BluetoothClientWorkflow
implements ItemAction,
DiscoveryListener,
PopupListener {
    protected BluetoothDevicePage m_devicePage;
    protected Popup m_popup;
    protected BackgammonConnection m_clientConnection = null;
    protected static final int REMOTE_DEVICE = 100;

    public BluetoothClientWorkflow(BluetoothDevicePage bluetoothDevicePage) {
        this.m_devicePage = bluetoothDevicePage;
    }

    public synchronized void refresh() {
        if (!this.m_devicePage.isSearching()) {
            this.m_devicePage.removeAllItems();
            try {
                DiscoveryAgent discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
                discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
                this.m_devicePage.setSearching(true);
            }
            catch (BluetoothStateException bluetoothStateException) {
                this.searchingStopped();
                bluetoothStateException.printStackTrace();
                Bluegammon.showPopup((Resources.getString(Resources.TXT_BT_DISC_FAIL) + "\n" + bluetoothStateException.getMessage()).toCharArray(), Popup.ALT_OK, 10, 0, 0, null);
            }
        }
    }

    public void searchingStopped() {
        this.m_devicePage.setSearching(false);
        if (this.m_devicePage.size() == 0) {
            Bluegammon.showPopup(Resources.getChars(Resources.TXT_BT_NO_DEVICES), Popup.ALT_OK, 60, 0, 0, null);
        }
    }

    public void itemAction(MenuPage menuPage, PageItem pageItem) {
        Object object = pageItem.getProperty(100);
        if (object != null) {
            RemoteDevice remoteDevice = (RemoteDevice)object;
            this.connectTo(remoteDevice, pageItem.getLabel());
        } else if (!this.m_devicePage.isSearching() && this.m_devicePage.size() == 0) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectedChoice(byte by, boolean bl) {
        Popup popup = Bluegammon.getCurrentPopup();
        if (popup != null) {
            popup.dispose();
        }
        BackgammonConnection backgammonConnection = null;
        BluetoothClientWorkflow bluetoothClientWorkflow = this;
        synchronized (bluetoothClientWorkflow) {
            backgammonConnection = this.m_clientConnection;
        }
        if (backgammonConnection != null) {
            try {
                backgammonConnection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectTo(RemoteDevice remoteDevice, char[] cArray) {
        block12: {
            this.m_popup = Bluegammon.showPopup((Resources.getString(Resources.TXT_BT_CONNECT) + " " + new String(cArray) + "...").toCharArray(), Popup.ALT_CANCEL, 0, 0, 0, this);
            Object object = this;
            synchronized (object) {
                if (this.m_clientConnection == null) {
                    this.m_clientConnection = new BackgammonBTConnection();
                }
            }
            try {
                if (!this.m_clientConnection.connectClient(remoteDevice)) {
                    Bluegammon.showPopup(Resources.getChars(Resources.TXT_BT_NONSERVER), Popup.ALT_OK, 60, 0, 0, null);
                    break block12;
                }
                if (this.m_popup != null) {
                    this.m_popup.dispose();
                    this.m_popup = null;
                }
                object = Resources.getChars(Resources.TXT_BT_UNKNOWN);
                try {
                    object = LocalDevice.getLocalDevice().getFriendlyName().toCharArray();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Bluegammon.setBackgammonConnection(this.m_clientConnection);
                Bluegammon.startRemoteGame(false, (char[])object);
            }
            catch (IOException iOException) {
                this.m_popup = null;
                Bluegammon.showPopup((Resources.getString(Resources.TXT_BT_CONN_FAIL) + "\n" + iOException.getMessage()).toCharArray(), Popup.ALT_OK, 60, 0, 0, null);
                iOException.printStackTrace();
                try {
                    this.m_clientConnection.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        Object object;
        char[] cArray = Resources.getChars(Resources.TXT_BT_UNKNOWN);
        try {
            object = remoteDevice.getFriendlyName(false);
            if (object != null) {
                cArray = ((String)object).toCharArray();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = new PageItem(cArray, null, this, null);
        ((PageItem)object).setProperty(100, remoteDevice);
        this.m_devicePage.addItem((PageItem)object);
    }

    public void inquiryCompleted(int n) {
        this.searchingStopped();
    }

    public void servicesDiscovered(int n, ServiceRecord[] serviceRecordArray) {
    }

    public void serviceSearchCompleted(int n, int n2) {
    }
}

