/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.animation;

import bluegammon.Resources;
import bluegammon.gui.BoardCanvas;
import bluegammon.gui.animation.AbstractDicesAnim;
import bluegammon.logic.BoardMediator;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class DicesSelectTurnAnim
extends AbstractDicesAnim {
    protected static final char[] TXT_BLACK_STARTS = Resources.getChars(Resources.TXT_A_BLACK_STARTS);
    protected static final char[] TXT_WHITE_STARTS = Resources.getChars(Resources.TXT_A_WHITE_STARTS);
    protected boolean m_white;
    protected boolean m_showTurnText = false;
    protected long m_showTurnTextCue;
    protected int m_width;
    protected int m_height;
    protected char[] m_text;
    protected static final Font FONT = Font.getFont((int)32, (int)1, (int)16);

    public DicesSelectTurnAnim(int n, int n2, int n3, int n4) {
        super(true, false, n, n2);
        this.m_width = n3;
        this.m_height = n4;
        this.m_white = n > n2;
        this.m_text = this.m_white ? TXT_WHITE_STARTS : TXT_BLACK_STARTS;
    }

    public void onStart() {
        super.onStart();
        BoardCanvas.getInstance().allowInteraction(false);
        BoardCanvas.getInstance().setDrawDiceValues(false);
        BoardCanvas.getInstance().updateCursor();
        BoardCanvas.getInstance().updateUndoCommand();
    }

    public void paint(Graphics graphics) {
        if (!this.m_showTurnText) {
            super.paint(graphics);
        } else {
            graphics.setFont(FONT);
            int n = this.m_width / 2;
            int n2 = this.m_height / 2 - FONT.getHeight() / 2;
            graphics.setColor(this.m_white ? 0 : 0xFFFFFF);
            graphics.drawChars(this.m_text, 0, this.m_text.length, n - 1, n2, 17);
            graphics.drawChars(this.m_text, 0, this.m_text.length, n + 1, n2, 17);
            graphics.drawChars(this.m_text, 0, this.m_text.length, n, n2 - 1, 17);
            graphics.drawChars(this.m_text, 0, this.m_text.length, n, n2 + 1, 17);
            graphics.setColor(this.m_white ? 0xFFFFFF : 0);
            graphics.drawChars(this.m_text, 0, this.m_text.length, n, n2, 17);
        }
    }

    public boolean isFinished() {
        if (super.isFinished()) {
            if (!this.m_showTurnText) {
                this.m_showTurnText = true;
                this.m_showTurnTextCue = System.currentTimeMillis();
            }
            return System.currentTimeMillis() > this.m_showTurnTextCue + 2000L;
        }
        return false;
    }

    public void onExit() {
        super.onExit();
        BoardMediator.newTurn(this.m_dice1 > this.m_dice2);
    }
}

