/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.animation;

import bluegammon.gui.BoardCanvas;
import bluegammon.gui.animation.Animation;
import bluegammon.gui.animation.WinnerAnim;
import bluegammon.logic.BoardMediator;
import javax.microedition.lcdui.Graphics;

public class WinnerPieceMoveAnim
extends Animation {
    protected WinnerAnim m_winAnim;
    protected int m_frames;
    protected boolean m_white;
    protected int m_x0;
    protected int m_y0;
    protected int m_x1;
    protected int m_y1;
    protected int m_frame = 0;
    protected float m_x;
    protected float m_y;
    protected int m_source;

    public WinnerPieceMoveAnim(WinnerAnim winnerAnim, boolean bl, int n, int n2, int n3, int n4) {
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        this.m_winAnim = winnerAnim;
        this.m_white = bl;
        this.m_source = n;
        this.m_x0 = boardCanvas.getPieceX(n, n4, bl);
        this.m_y0 = boardCanvas.getPieceY(n, n4, bl);
        this.m_x1 = n2;
        this.m_y1 = n3;
        this.m_x = this.m_x0;
        this.m_y = this.m_y0;
        this.m_frames = 30;
    }

    public void onStart() {
        BoardCanvas.getInstance().removePiece(this.m_white, this.m_source);
    }

    public void paint(Graphics graphics) {
        float f = (float)this.m_frame / (float)this.m_frames;
        float f2 = 55.0f * f;
        float f3 = 270.0f * f;
        BoardCanvas.getInstance().drawPiece((int)this.m_x, (int)this.m_y, f3, true, f2, this.m_white, graphics);
    }

    public void next() {
        BoardCanvas boardCanvas = BoardCanvas.getInstance();
        this.m_x = (float)(this.m_x1 - this.m_x0) * (float)this.m_frame / (float)this.m_frames + (float)this.m_x0;
        this.m_y = (float)(this.m_y1 - this.m_y0) * (float)this.m_frame / (float)this.m_frames + (float)this.m_y0;
        boardCanvas.requestRepaint();
        ++this.m_frame;
    }

    public boolean isFinished() {
        return !BoardMediator.isGameFinished() || this.m_frame > this.m_frames;
    }

    public void onExit() {
        this.m_winAnim.piecePlus();
    }

    public long getInterval() {
        return 20L;
    }
}

