/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.io;

import bluegammon.io.BackgammonConnection;
import bluegammon.io.BluetoothFacade;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.StreamConnection;

public class BackgammonBTConnection
implements BackgammonConnection {
    protected static final String SERVICE_NBR = "1a88760401bac57a8806abc1ca900010";
    protected static final BluetoothFacade BTFACADE = new BluetoothFacade();
    protected static boolean m_awaitingClient = false;
    protected static boolean m_fakeServerClosed = false;
    protected static boolean m_closed = false;
    protected static volatile StreamConnection m_connection;
    protected static volatile DataInputStream m_input;
    protected static volatile DataOutputStream m_output;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForClient() throws IOException {
        BackgammonBTConnection backgammonBTConnection = this;
        synchronized (backgammonBTConnection) {
            if (m_awaitingClient && m_fakeServerClosed) {
                m_fakeServerClosed = false;
                return;
            }
            m_awaitingClient = true;
            m_fakeServerClosed = false;
        }
        try {
            m_closed = false;
            m_connection = BTFACADE.waitForClient(SERVICE_NBR);
            m_input = m_connection.openDataInputStream();
            m_output = m_connection.openDataOutputStream();
        }
        catch (IOException iOException) {
            BackgammonBTConnection backgammonBTConnection2 = this;
            synchronized (backgammonBTConnection2) {
                if (!m_closed && !m_fakeServerClosed) {
                    throw iOException;
                }
            }
        }
        finally {
            BackgammonBTConnection backgammonBTConnection3 = this;
            synchronized (backgammonBTConnection3) {
                m_awaitingClient = false;
                if (m_fakeServerClosed) {
                    this.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectClient(Object object) throws IOException {
        BackgammonBTConnection backgammonBTConnection = this;
        synchronized (backgammonBTConnection) {
            m_closed = false;
        }
        boolean bl = false;
        try {
            m_connection = BTFACADE.connect(SERVICE_NBR, (RemoteDevice)object);
            if (m_connection != null) {
                m_input = m_connection.openDataInputStream();
                m_output = m_connection.openDataOutputStream();
                bl = true;
            }
        }
        catch (IOException iOException) {
            BackgammonBTConnection backgammonBTConnection2 = this;
            synchronized (backgammonBTConnection2) {
                if (!m_closed) {
                    throw iOException;
                }
            }
        }
        finally {
            BackgammonBTConnection backgammonBTConnection3 = this;
            synchronized (backgammonBTConnection3) {
                if (m_closed) {
                    this.close();
                }
            }
        }
        return bl;
    }

    public StreamConnection getConnection() throws IOException {
        return m_connection;
    }

    public DataInputStream getInput() {
        return m_input;
    }

    public DataOutputStream getOutput() {
        return m_output;
    }

    public synchronized void pretendServerClose() {
        m_fakeServerClosed = true;
    }

    public synchronized boolean isAwaitingClient() {
        return m_awaitingClient;
    }

    public synchronized void close() throws IOException {
        IOException iOException = null;
        m_closed = true;
        if (m_connection != null) {
            try {
                m_connection.close();
                m_connection = null;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (m_input != null) {
            try {
                m_input.close();
                m_input = null;
            }
            catch (IOException iOException3) {
                iOException = iOException3;
            }
        }
        if (m_output != null) {
            try {
                m_output.close();
                m_output = null;
            }
            catch (IOException iOException4) {
                iOException = iOException4;
            }
        }
        try {
            BTFACADE.closeServer(SERVICE_NBR);
            m_awaitingClient = false;
        }
        catch (IOException iOException5) {
            iOException = iOException5;
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    public synchronized boolean isClosed() {
        return m_closed || m_fakeServerClosed;
    }
}

