/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.io;

import bluegammon.Device;
import bluegammon.RmsFacade;
import bluegammon.logic.GameRecord;
import bluegammon.logic.Rand;
import bluegammon.logic.Rules;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Handshake {
    protected int m_remoteId;
    protected char[] m_remoteName;
    protected byte[] m_savedGame;
    protected boolean m_white;
    protected boolean m_remoteResume;

    public void serverHandshake(DataInputStream dataInputStream, DataOutputStream dataOutputStream, String string) throws IOException {
        int n;
        this.m_savedGame = null;
        long l = dataInputStream.readLong();
        Rand.setRandomSeed(l);
        this.m_remoteId = dataInputStream.readInt();
        this.m_remoteName = dataInputStream.readUTF().toCharArray();
        this.m_savedGame = GameRecord.getSavedGame(this.m_remoteId);
        boolean bl = this.m_savedGame != null;
        dataOutputStream.writeBoolean(bl);
        if (bl) {
            this.m_remoteResume = false;
            dataOutputStream.writeInt(this.m_savedGame.length);
            for (n = 0; n < this.m_savedGame.length; ++n) {
                dataOutputStream.writeByte(this.m_savedGame[n]);
            }
        }
        dataOutputStream.writeInt(Device.getDeviceId());
        dataOutputStream.writeUTF(string);
        this.m_white = !RmsFacade.getBoolean(4);
        dataOutputStream.writeBoolean(!this.m_white);
        if (!bl) {
            Rules.saveRules(dataOutputStream);
        }
        dataOutputStream.flush();
        if (!bl && (n = (int)(dataInputStream.readBoolean() ? 1 : 0)) != 0) {
            this.m_remoteResume = true;
            int n2 = dataInputStream.readInt();
            this.m_savedGame = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                this.m_savedGame[i] = dataInputStream.readByte();
            }
        }
    }

    public void clientHandshake(DataInputStream dataInputStream, DataOutputStream dataOutputStream, String string) throws IOException {
        int n;
        int n2;
        this.m_savedGame = null;
        long l = System.currentTimeMillis();
        Rand.setRandomSeed(l);
        dataOutputStream.writeLong(l);
        dataOutputStream.writeInt(Device.getDeviceId());
        dataOutputStream.writeUTF(string);
        dataOutputStream.flush();
        boolean bl = dataInputStream.readBoolean();
        if (bl) {
            this.m_remoteResume = true;
            n2 = dataInputStream.readInt();
            this.m_savedGame = new byte[n2];
            for (n = 0; n < n2; ++n) {
                this.m_savedGame[n] = dataInputStream.readByte();
            }
        }
        this.m_remoteId = dataInputStream.readInt();
        this.m_remoteName = dataInputStream.readUTF().toCharArray();
        this.m_white = dataInputStream.readBoolean();
        if (!bl) {
            Rules.loadRules(dataInputStream);
        }
        if (!bl) {
            this.m_savedGame = GameRecord.getSavedGame(this.m_remoteId);
            n2 = this.m_savedGame != null ? 1 : 0;
            dataOutputStream.writeBoolean(n2 != 0);
            if (n2 != 0) {
                this.m_remoteResume = false;
                dataOutputStream.writeInt(this.m_savedGame.length);
                for (n = 0; n < this.m_savedGame.length; ++n) {
                    dataOutputStream.writeByte(this.m_savedGame[n]);
                }
            }
            dataOutputStream.flush();
        }
    }

    public int getRemoteId() {
        return this.m_remoteId;
    }

    public char[] getRemoteName() {
        return this.m_remoteName;
    }

    public byte[] getSavedGame() {
        return this.m_savedGame;
    }

    public boolean isWhite() {
        return this.m_white;
    }

    public boolean isRemoteResume() {
        return this.m_remoteResume;
    }
}

