/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.logic;

import bluegammon.RmsFacade;
import bluegammon.logic.Player;
import java.util.Date;
import java.util.Vector;

public class GameRecord {
    protected int m_opponentId;
    protected char[] m_opponentName;
    protected int m_gameCount;
    protected int m_playerScore;
    protected int m_opponentScore;
    protected long m_timestamp;
    protected int m_gameRecordIndex;

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public int getOpponentId() {
        return this.m_opponentId;
    }

    public char[] getOpponentName() {
        return this.m_opponentName;
    }

    public int getOpponentScore() {
        return this.m_opponentScore;
    }

    public int getPlayerScore() {
        return this.m_playerScore;
    }

    public int getGameCount() {
        return this.m_gameCount;
    }

    public int getIndex() {
        return this.m_gameRecordIndex;
    }

    protected void registerGame(boolean bl, int n) {
        this.m_playerScore += bl ? n : 0;
        this.m_opponentScore += bl ? 0 : n;
        ++this.m_gameCount;
    }

    protected void setIndex(int n) {
        this.m_gameRecordIndex = n;
    }

    protected void save() {
        this.m_timestamp = new Date().getTime();
        RmsFacade.setInt(8 + this.m_gameRecordIndex, this.m_opponentId);
        RmsFacade.setChars(24 + this.m_gameRecordIndex, this.m_opponentName);
        RmsFacade.setInt(40 + this.m_gameRecordIndex, this.m_playerScore);
        RmsFacade.setInt(56 + this.m_gameRecordIndex, this.m_opponentScore);
        RmsFacade.setInt(72 + this.m_gameRecordIndex, this.m_gameCount);
        RmsFacade.setLong(88 + this.m_gameRecordIndex, this.m_timestamp);
    }

    protected GameRecord(int n) {
        this.m_opponentId = RmsFacade.getInt(8 + n);
        this.m_opponentName = RmsFacade.getChars(24 + n);
        this.m_playerScore = RmsFacade.getInt(40 + n);
        this.m_opponentScore = RmsFacade.getInt(56 + n);
        this.m_gameCount = RmsFacade.getInt(72 + n);
        this.m_timestamp = RmsFacade.getLong(88 + n);
        this.m_gameRecordIndex = n;
    }

    protected GameRecord(Player player) {
        this.m_opponentId = player.getId();
        this.m_opponentName = player.getName();
        this.m_playerScore = 0;
        this.m_opponentScore = 0;
        this.m_gameCount = 0;
    }

    public static byte[] getSavedGame(int n) {
        byte[] byArray = null;
        int n2 = GameRecord.getIndexForOpponentId(n);
        if (n2 >= 0) {
            byArray = RmsFacade.get(104 + n2);
        }
        return byArray;
    }

    public static void saveGame(Player player, byte[] byArray) {
        GameRecord gameRecord = GameRecord.getRecordForce(player);
        RmsFacade.set(104 + gameRecord.getIndex(), byArray);
        gameRecord.save();
    }

    public static int countRecords() {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            int n2 = RmsFacade.getInt(8 + i);
            if (n2 == 0) continue;
            ++n;
        }
        return n;
    }

    public static Vector getAllRecords() {
        Vector<GameRecord> vector = new Vector<GameRecord>();
        for (int i = 0; i < 16; ++i) {
            int n = RmsFacade.getInt(8 + i);
            if (n == 0) continue;
            GameRecord gameRecord = new GameRecord(i);
            vector.addElement(gameRecord);
        }
        return vector;
    }

    public static GameRecord getRecord(Player player) {
        int n = player.getId();
        int n2 = GameRecord.getIndexForOpponentId(n);
        return n2 >= 0 ? new GameRecord(n2) : null;
    }

    public static void updateGameResult(Player player, boolean bl, int n) {
        GameRecord gameRecord = GameRecord.getRecordForce(player);
        gameRecord.registerGame(bl, n);
        gameRecord.save();
    }

    protected static GameRecord getRecordForce(Player player) {
        int n = 0;
        GameRecord gameRecord = GameRecord.getRecord(player);
        if (gameRecord == null) {
            gameRecord = new GameRecord(player);
            int n2 = GameRecord.countRecords();
            Vector vector = GameRecord.getAllRecords();
            if (n2 >= 16) {
                long l = Long.MAX_VALUE;
                for (int i = 0; i < n2; ++i) {
                    long l2 = ((GameRecord)vector.elementAt(i)).getTimestamp();
                    if (l <= l2) continue;
                    n = ((GameRecord)vector.elementAt(i)).getIndex();
                    l = l2;
                }
            } else {
                int n3;
                for (n = 0; n < 16 && (n3 = RmsFacade.getInt(8 + n)) != 0; ++n) {
                }
                System.out.println("                              got index " + n);
            }
        } else {
            n = gameRecord.getIndex();
            System.out.println("                              existing record, index " + n);
        }
        gameRecord.setIndex(n);
        return gameRecord;
    }

    protected static int getIndexForOpponentId(int n) {
        int n2 = -1;
        for (int i = 0; i < 16; ++i) {
            int n3 = RmsFacade.getInt(8 + i);
            if (n3 != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }
}

