/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.logic;

import bluegammon.Bluegammon;
import bluegammon.Resources;
import bluegammon.gui.BoardCanvas;
import bluegammon.gui.StringInputHandler;
import bluegammon.gui.popup.PopupListener;
import bluegammon.logic.BoardMediator;
import bluegammon.logic.Player;
import javax.microedition.lcdui.Command;

public class LocalPlayer
extends Player
implements StringInputHandler,
PopupListener {
    protected BoardCanvas m_canvas;

    public LocalPlayer(int n, char[] cArray, boolean bl, BoardCanvas boardCanvas) {
        this.init(n, cArray, bl);
        this.m_canvas = boardCanvas;
    }

    public boolean keyPressed(int n, int n2) {
        boolean bl = BoardMediator.isCurrentPlayerWhite();
        boolean bl2 = false;
        if (BoardMediator.isGameFinished() || !this.m_canvas.isUserMovable()) {
            return bl2;
        }
        if (!this.m_canvas.waitingForCommit()) {
            if (BoardMediator.countPossibleMoves() == 0 && BoardMediator.countUndoableMoves() == 0) {
                BoardMediator.newTurn(!bl);
                this.fireTurnCommit();
                bl2 = true;
            } else {
                switch (n2) {
                    case 2: 
                    case 5: {
                        this.m_canvas.cursorSwapSide();
                        break;
                    }
                    case 1: {
                        this.m_canvas.cursorBackIndex();
                        break;
                    }
                    case 6: {
                        this.m_canvas.cursorNextIndex();
                        break;
                    }
                    case 8: {
                        if (this.m_canvas.isCursorValid()) {
                            int n3 = this.m_canvas.getCurrentCursorIndex();
                            int n4 = BoardMediator.getPossibleMoves()[n3][0];
                            int n5 = BoardMediator.getPossibleMoves()[n3][1];
                            BoardMediator.makePlayerMove(n3);
                            this.fireMoveMade(n3);
                            if (BoardMediator.countPossibleMoves() > 0) {
                                this.m_canvas.cursorNearestIndex(n4, n5);
                            }
                        }
                        if (BoardMediator.countPossibleMoves() == 0) {
                            this.m_canvas.setQueryCommit(true);
                        }
                        this.m_canvas.updateUndoCommand();
                    }
                }
                this.m_canvas.updateCursor();
            }
            bl2 = true;
        } else {
            BoardMediator.commitTurn();
            this.fireTurnCommit();
            bl2 = true;
        }
        return bl2;
    }

    public boolean commandAction(Command command) {
        boolean bl = false;
        if (command == BoardCanvas.CMD_UNDO) {
            BoardMediator.undoLastMove();
            this.fireUndoPerformed();
            bl = true;
        } else if (command == BoardCanvas.CMD_EXIT) {
            if (Bluegammon.getGameType() == Bluegammon.GAME_TYPE_LOCAL) {
                this.fireGameExited(0);
                BoardMediator.exitGame(0);
            } else if (BoardMediator.isGameFinished()) {
                this.fireGameExited(0);
                BoardMediator.exitGame(0);
            } else {
                char[][] cArrayArray = new char[][]{Resources.getChars(Resources.TXT_GIVE_UP), Resources.getChars(Resources.TXT_SAVE_GAME), Resources.getChars(Resources.TXT_CANCEL)};
                Bluegammon.showPopup(Resources.getChars(Resources.TXT_QUIT_REMOTE), cArrayArray, 0, 2, 2, this);
            }
            bl = true;
        }
        return bl;
    }

    public void handleStringInput(String string) {
        if (string != null) {
            this.fireMessageSent(string.toCharArray());
        }
    }

    public void selectedChoice(byte by, boolean bl) {
        switch (by) {
            case 0: {
                this.fireGameExited(2);
                BoardMediator.exitGame(2);
                break;
            }
            case 1: {
                this.fireGameExited(0);
                BoardMediator.exitGame(0);
                break;
            }
        }
    }
}

