/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.logic;

import bluegammon.logic.PlayerListener;
import java.util.Vector;

public abstract class Player {
    protected int m_id;
    protected char[] m_name;
    protected boolean m_white;
    protected Vector m_listeners = new Vector();

    public void init(int n, char[] cArray, boolean bl) {
        this.m_id = n;
        this.m_name = cArray;
        this.setWhite(bl);
    }

    public void setWhite(boolean bl) {
        this.m_white = bl;
    }

    public int getId() {
        return this.m_id;
    }

    public char[] getName() {
        return this.m_name;
    }

    public boolean isWhite() {
        return this.m_white;
    }

    public void addListener(PlayerListener playerListener) {
        this.m_listeners.addElement(playerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMoveMade(int n) {
        Vector vector = this.m_listeners;
        synchronized (vector) {
            for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
                ((PlayerListener)this.m_listeners.elementAt(i)).moveMade(this.getId(), n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUndoPerformed() {
        Vector vector = this.m_listeners;
        synchronized (vector) {
            for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
                ((PlayerListener)this.m_listeners.elementAt(i)).undoPerformed(this.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTurnCommit() {
        Vector vector = this.m_listeners;
        synchronized (vector) {
            for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
                ((PlayerListener)this.m_listeners.elementAt(i)).turnCommit(this.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireGameExited(int n) {
        Vector vector = this.m_listeners;
        synchronized (vector) {
            for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
                ((PlayerListener)this.m_listeners.elementAt(i)).gameExited(this.getId(), n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMessageSent(char[] cArray) {
        Vector vector = this.m_listeners;
        synchronized (vector) {
            for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
                ((PlayerListener)this.m_listeners.elementAt(i)).messageSent(this.getId(), cArray);
            }
        }
    }
}

