/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.popup;

import bluegammon.Resources;
import bluegammon.gui.popup.PopupListener;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Popup
implements Runnable {
    public static final char[][] ALT_OK = new char[1][];
    public static final char[][] ALT_CANCEL;
    public static final char[][] ALT_YES_NO;
    public static final char[][] ALT_OK_CANCEL;
    public static final char[][] ALT_YES_NO_CANCEL;
    protected char[] m_text;
    protected byte m_alternatives;
    protected char[][] m_altTexts;
    protected byte m_timeOut;
    protected byte m_timeOutAlt;
    protected byte m_curAlt;
    protected PopupListener m_listener;
    protected volatile boolean m_active = true;
    protected int m_w;
    protected int m_h;
    protected int[][] m_breakTextData;
    protected int m_visibleLines;
    protected int m_curLine;
    protected int m_maxLine;
    protected int m_yoffset;
    protected long m_endTime;
    protected Font m_font = Font.getFont((int)32, (int)1, (int)8);
    protected int m_fontHeight = this.m_font.getHeight();
    protected int m_borderColor = 0xDD0000;
    protected int m_backgroundColor = -867958784;
    protected int m_textColor = 0xFFFFFF;
    protected int m_alternativeColor = 0xFF2200;
    protected int m_selectedAlternativeColor = 0xFFFFFF;
    protected static int[] m_rgbData;
    protected static final int OFFSET_POPUP = 8;
    protected static final int OFFSET_TEXT = 2;
    protected static final int OFFSET_ALT = 4;
    protected static final int SB_WIDTH = 5;
    protected static final char[] TEXTBREAKS;
    protected static final char NEWLINE = '\n';

    public void init(char[] cArray, char[][] cArray2, byte by, byte by2, byte by3, PopupListener popupListener, int n, int n2) {
        int n3;
        this.m_text = cArray;
        this.m_altTexts = cArray2;
        this.m_alternatives = cArray2 != null ? (byte)cArray2.length : (byte)0;
        this.m_timeOut = by;
        this.m_timeOutAlt = by3;
        this.m_listener = popupListener;
        this.m_curAlt = by2;
        this.m_w = n - 16;
        this.m_h = n2 - 16;
        this.m_active = true;
        this.m_endTime = this.m_timeOut > 0 ? System.currentTimeMillis() + (long)(this.m_timeOut * 1000) : (this.m_alternatives > 0 ? 0L : System.currentTimeMillis());
        this.m_visibleLines = Math.max(1, (this.m_h - 4) / this.m_fontHeight - 1);
        int n4 = this.m_w - 4 - 10;
        this.m_curLine = 0;
        this.m_breakTextData = this.breakString(cArray, n4);
        this.m_yoffset = 0;
        this.m_maxLine = this.m_breakTextData.length - this.m_visibleLines + 1;
        if (this.m_breakTextData.length < this.m_visibleLines) {
            n3 = this.m_breakTextData.length * this.m_fontHeight;
            if (this.m_alternatives > 0) {
                n3 += this.m_fontHeight;
            }
            this.m_yoffset = this.m_h - (n3 += 6) >> 1;
            this.m_h = n3;
        }
        if (m_rgbData == null || m_rgbData.length != this.m_w * 8) {
            m_rgbData = new int[this.m_w * 8];
            for (n3 = 0; n3 < m_rgbData.length; ++n3) {
                Popup.m_rgbData[n3] = this.m_backgroundColor;
            }
        }
        new Thread((Runnable)this, "PopupPoll").start();
    }

    protected int[][] breakString(char[] cArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        while (n3 < cArray.length) {
            n3 = n2 = this.findNextBreak(cArray, n3, cArray.length - n3, n, this.m_font);
            ++n4;
        }
        int[][] nArray = new int[n4][2];
        n4 = 0;
        n3 = 0;
        while (n3 < cArray.length) {
            n2 = this.findNextBreak(cArray, n3, cArray.length - n3, n, this.m_font);
            nArray[n4][0] = n3;
            nArray[n4][1] = n2 - n3;
            ++n4;
            n3 = n2;
        }
        return nArray;
    }

    public int findNextBreak(char[] cArray, int n, int n2, int n3, Font font) {
        char c;
        int n4 = n;
        int n5 = -1;
        for (int i = 0; n4 <= n + n2 && i < n3; ++n4, i += font.charWidth(c)) {
            c = n4 == n + n2 ? TEXTBREAKS[0] : cArray[n4];
            if (c == '\n') {
                n5 = n4;
                break;
            }
            for (int j = TEXTBREAKS.length - 1; j >= 0; --j) {
                if (c != TEXTBREAKS[j]) continue;
                n5 = n4;
                break;
            }
            if (n4 != n + n2 - 1) continue;
            n5 = n4 + 1;
        }
        if (n5 > n && n5 < n + n2 - 2 && cArray[n5 + 1] == ' ') {
            return n5 + 2;
        }
        if (n5 > n && n5 < n + n2) {
            return n5 + 1;
        }
        if (n4 > n + 1) {
            return n4 - 1;
        }
        if (n4 == n) {
            return n4 + 1;
        }
        return n4;
    }

    public void paint(Graphics graphics) {
        if (this.m_active) {
            int n;
            int n2;
            int n3;
            int n4;
            for (n4 = 8 + this.m_yoffset; n4 < 8 + this.m_yoffset + this.m_h; n4 += 8) {
                graphics.drawRGB(m_rgbData, 0, this.m_w, 8, n4, this.m_w, Math.min(8, 8 + this.m_yoffset + this.m_h - n4), true);
            }
            graphics.setColor(this.m_borderColor);
            graphics.drawRect(8, 8 + this.m_yoffset, this.m_w, this.m_h);
            graphics.setColor(this.m_textColor);
            graphics.setFont(this.m_font);
            n4 = 10 + this.m_yoffset;
            int n5 = Math.min(this.m_curLine + this.m_visibleLines, this.m_breakTextData.length);
            for (n3 = this.m_curLine; n3 < n5; ++n3) {
                n2 = this.m_breakTextData[n3][0];
                n = this.m_breakTextData[n3][1];
                if (n == 1 && this.m_text[n2] == '\n') {
                    n4 += this.m_fontHeight;
                    continue;
                }
                if (this.m_text[n2 + n - 1] == '\n') {
                    --n;
                }
                graphics.drawChars(this.m_text, n2, n, 10 + (this.m_w >> 1), n4, 17);
                n4 += this.m_fontHeight;
            }
            if (this.m_visibleLines < this.m_breakTextData.length) {
                n3 = this.m_visibleLines * this.m_fontHeight;
                n2 = (n3 - 4 << 8) / this.m_maxLine;
                n = 8 + this.m_w - 5 - 2;
                graphics.setColor(this.m_textColor);
                graphics.fillRect(n, 10 + (this.m_curLine * n2 >> 8), 5, 4 + (n2 >> 8));
            }
            if (this.m_alternatives > 0) {
                n4 = 10 + this.m_h + this.m_yoffset - 2 - this.m_fontHeight;
                n3 = this.m_w / (this.m_alternatives + 1);
                n2 = 10;
                for (n = 0; n < this.m_alternatives; ++n) {
                    char[] cArray = this.m_altTexts[n];
                    int n6 = (n2 += n3) - (this.m_font.charsWidth(cArray, 0, cArray.length) >> 1);
                    if (this.m_curAlt != n) {
                        graphics.setColor(this.m_alternativeColor);
                        graphics.drawChars(cArray, 0, cArray.length, n6, n4, 20);
                        continue;
                    }
                    graphics.setColor(this.m_alternativeColor);
                    graphics.drawChars(cArray, 0, cArray.length, n6 + 1, n4 + 1, 20);
                    graphics.setColor(this.m_selectedAlternativeColor);
                    graphics.drawChars(cArray, 0, cArray.length, n6, n4, 20);
                }
            }
        }
    }

    public void keyPressed(int n, int n2) {
        if (this.m_active) {
            if (this.m_alternatives < 1) {
                this.m_active = false;
                if (this.m_listener != null) {
                    this.m_listener.selectedChoice(this.m_curAlt, false);
                }
            } else {
                switch (n2) {
                    case 6: {
                        ++this.m_curLine;
                        if (this.m_curLine < this.m_maxLine) break;
                        this.m_curLine = 0;
                        break;
                    }
                    case 1: {
                        if (this.m_maxLine > 0) {
                            --this.m_curLine;
                        }
                        if (this.m_curLine >= 0) break;
                        this.m_curLine = this.m_maxLine - 1;
                        break;
                    }
                    case 5: {
                        this.m_curAlt = (byte)(this.m_curAlt + 1);
                        if (this.m_curAlt < this.m_alternatives) break;
                        this.m_curAlt = 0;
                        break;
                    }
                    case 2: {
                        this.m_curAlt = (byte)(this.m_curAlt - 1);
                        if (this.m_curAlt >= 0) break;
                        this.m_curAlt = (byte)(this.m_alternatives - 1);
                        break;
                    }
                    case 8: {
                        if (this.m_curAlt < 0) break;
                        this.m_active = false;
                        if (this.m_listener == null) break;
                        this.m_listener.selectedChoice(this.m_curAlt, false);
                        break;
                    }
                    case -11: {
                        this.m_active = false;
                        if (this.m_listener == null) break;
                        this.m_listener.selectedChoice(this.m_timeOutAlt, false);
                    }
                }
            }
        }
    }

    public void dispose() {
        this.m_active = false;
        this.m_text = null;
        this.m_altTexts = null;
        this.m_listener = null;
        this.m_breakTextData = null;
        System.gc();
    }

    public boolean isActive() {
        return this.m_active;
    }

    public byte getTimeOutChoice() {
        return this.m_timeOutAlt;
    }

    protected boolean pollTimeout() {
        if (this.m_active && this.m_endTime > 0L && System.currentTimeMillis() > this.m_endTime) {
            this.m_active = false;
            if (this.m_listener != null) {
                this.m_listener.selectedChoice(this.m_timeOutAlt, true);
                return true;
            }
        }
        return false;
    }

    public void run() {
        while (this.isActive()) {
            try {
                Thread.sleep(1000L);
                this.pollTimeout();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static {
        Popup.ALT_OK[0] = Resources.getChars(Resources.TXT_OK);
        ALT_CANCEL = new char[1][];
        Popup.ALT_CANCEL[0] = Resources.getChars(Resources.TXT_CANCEL);
        ALT_YES_NO = new char[2][];
        Popup.ALT_YES_NO[0] = Resources.getChars(Resources.TXT_YES);
        Popup.ALT_YES_NO[1] = Resources.getChars(Resources.TXT_NO);
        ALT_OK_CANCEL = new char[2][];
        Popup.ALT_OK_CANCEL[0] = ALT_OK[0];
        Popup.ALT_OK_CANCEL[1] = ALT_CANCEL[0];
        ALT_YES_NO_CANCEL = new char[3][];
        Popup.ALT_YES_NO_CANCEL[0] = ALT_YES_NO[0];
        Popup.ALT_YES_NO_CANCEL[1] = ALT_YES_NO[1];
        Popup.ALT_YES_NO_CANCEL[2] = ALT_CANCEL[0];
        TEXTBREAKS = new char[]{' ', '?', ';', ',', '.', '!', ':', '-', '=', '(', ')', '[', ']'};
    }
}

