/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.logic;

import bluegammon.logic.BoardMediator;
import bluegammon.logic.Player;
import bluegammon.logic.PlayerListener;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;

public class RemotePlayer
extends Player
implements PlayerListener,
Runnable {
    protected DataInputStream m_in;

    public RemotePlayer(int n, char[] cArray, boolean bl, DataInputStream dataInputStream) {
        this.init(n, cArray, bl);
        this.m_in = dataInputStream;
        new Thread((Runnable)this, "RemotePlayer").start();
    }

    public void moveMade(int n, int n2) {
        BoardMediator.makePlayerMove(n2);
        this.fireMoveMade(n2);
    }

    public void undoPerformed(int n) {
        BoardMediator.undoLastMove();
        this.fireUndoPerformed();
    }

    public void turnCommit(int n) {
        BoardMediator.commitTurn();
        this.fireTurnCommit();
    }

    public void messageSent(int n, char[] cArray) {
        BoardMediator.showMessage(cArray);
        this.fireMessageSent(cArray);
    }

    public void gameExited(int n, int n2) {
        this.fireGameExited(n2);
        BoardMediator.exitGame(n2);
    }

    public void run() {
        block12: {
            boolean bl = true;
            try {
                while (bl) {
                    byte by = this.m_in.readByte();
                    int n = this.m_in.readInt();
                    switch (by) {
                        case 0: {
                            int n2 = this.m_in.readInt();
                            this.moveMade(n, n2);
                            break;
                        }
                        case 1: {
                            this.undoPerformed(n);
                            break;
                        }
                        case 2: {
                            this.turnCommit(n);
                            break;
                        }
                        case 4: {
                            int n3 = this.m_in.readInt();
                            bl = false;
                            this.gameExited(n, n3);
                            break;
                        }
                        case 3: {
                            String string = this.m_in.readUTF();
                            this.messageSent(n, string.toCharArray());
                        }
                    }
                }
            }
            catch (EOFException eOFException) {
                System.err.println("RemotePlayer.run premature eof");
                if (bl) {
                    BoardMediator.lostRemoteConnection(eOFException);
                }
            }
            catch (IOException iOException) {
                System.err.println("RemotePlayer.run IOException");
                if (!bl) break block12;
                BoardMediator.lostRemoteConnection(iOException);
            }
        }
    }
}

