/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.logic;

import bluegammon.logic.BoardState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Rules {
    public static final int MAX_FIVE = 1;
    public static final int EVEN_OUT = 2;
    protected static int RULEFLAGS = 0;
    private static final int FULLMASK = 3;

    public static boolean isAnyRuleSet() {
        return RULEFLAGS != 0;
    }

    public static void set(int n, boolean bl) {
        RULEFLAGS = bl ? (RULEFLAGS |= n) : (RULEFLAGS &= 3 ^ n);
    }

    public static boolean isSet(int n) {
        return (RULEFLAGS & n) != 0;
    }

    public static boolean isValidFromGuard(BoardState boardState, int n, int[] nArray, int[] nArray2) {
        boolean bl;
        boolean bl2 = bl = nArray2[n] < 2;
        if (Rules.isSet(1)) {
            bl &= nArray[n] < 5;
        }
        return bl;
    }

    public static boolean isValidMove(BoardState boardState, int n, int n2, boolean bl, int[] nArray, int[] nArray2) {
        if (n2 <= 23) {
            boolean bl2;
            boolean bl3 = bl2 = nArray2[n2] < 2;
            if (Rules.isSet(1)) {
                bl2 &= nArray[n2] < 5;
            }
            return bl2;
        }
        if (n2 > 23) {
            boolean bl4;
            boolean bl5 = bl4 = boardState.areAllPiecesHome(bl) && (n2 == 24 || boardState.isNoneBefore(bl, n));
            if (Rules.isSet(2)) {
                bl4 &= n2 == 24;
            }
            return bl4;
        }
        return false;
    }

    public static int getRuleFlags() {
        return RULEFLAGS;
    }

    public static void setRuleFlags(int n) {
        RULEFLAGS = n;
    }

    public static int loadRules(DataInputStream dataInputStream) throws IOException {
        RULEFLAGS = dataInputStream.readInt();
        return 4;
    }

    public static int saveRules(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(RULEFLAGS);
        return 4;
    }

    private Rules() {
    }
}

