/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class BackTrace
extends List
implements CommandListener {
    PCalc calc;
    Debugger debugger;
    VirtualMachine vm;

    private static String formatAddress(int n) {
        String string = "00" + n;
        return string.substring(string.length() - 3);
    }

    BackTrace(PCalc pCalc, Debugger debugger, VirtualMachine virtualMachine) {
        super("Back trace", 3);
        this.calc = pCalc;
        this.debugger = debugger;
        this.vm = virtualMachine;
        int n = virtualMachine.cSp;
        while (--n >= 0) {
            this.append(BackTrace.formatAddress(n) + ": " + virtualMachine.callStack[n].proc.name, null);
        }
        this.setCommandListener(this);
        this.addCommand(PCalc.OK_CMD);
        Display.getDisplay((MIDlet)pCalc).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == PCalc.OK_CMD) {
            this.debugger.goBack();
        } else {
            int n = this.vm.cSp - this.getSelectedIndex() - 1;
            new InspectVariables(this.calc, (Displayable)this, this.vm.callStack[n]);
        }
    }
}

