/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class Debugger
extends List
implements CommandListener {
    PCalc calc;
    Launcher parent;
    VirtualMachine vm;
    Procedure curr;
    int selectedIndex;

    Debugger(PCalc pCalc, Launcher launcher, Program program) {
        super("Debugger", 3);
        this.calc = pCalc;
        this.parent = launcher;
        this.vm = new VirtualMachine(program);
        this.curr = program.main;
        String[] stringArray = VirtualMachine.printInstructions(this.curr);
        for (int i = 0; i < stringArray.length; ++i) {
            this.append(stringArray[i], null);
        }
        this.setCommandListener(this);
        this.addCommand(PCalc.STEP_CMD);
        this.addCommand(PCalc.CONTINUE_CMD);
        this.addCommand(PCalc.RESTART_CMD);
        this.addCommand(PCalc.VARIABLES_CMD);
        this.addCommand(PCalc.STACK_CMD);
        this.addCommand(PCalc.TRACE_CMD);
        this.addCommand(PCalc.CANCEL_CMD);
        Display.getDisplay((MIDlet)pCalc).setCurrent((Displayable)this);
    }

    Debugger(PCalc pCalc, Launcher launcher, VirtualMachine virtualMachine, boolean bl) {
        super("Debugger", 3);
        this.calc = pCalc;
        this.parent = launcher;
        this.vm = virtualMachine;
        this.curr = virtualMachine.currFrame.proc;
        String[] stringArray = VirtualMachine.printInstructions(this.curr);
        for (int i = 0; i < stringArray.length; ++i) {
            this.append(stringArray[i], null);
        }
        this.setSelectedIndex(VirtualMachine.getInstructionForPc(this.curr.code, virtualMachine.currFrame.pc), true);
        this.setCommandListener(this);
        if (bl) {
            this.addCommand(PCalc.STEP_CMD);
            this.addCommand(PCalc.CONTINUE_CMD);
        }
        this.addCommand(PCalc.RESTART_CMD);
        this.addCommand(PCalc.VARIABLES_CMD);
        this.addCommand(PCalc.STACK_CMD);
        this.addCommand(PCalc.TRACE_CMD);
        this.addCommand(PCalc.CANCEL_CMD);
        Display.getDisplay((MIDlet)pCalc).setCurrent((Displayable)this);
    }

    void goBack() {
        this.setSelectedIndex(this.selectedIndex, true);
        Display.getDisplay((MIDlet)this.calc).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        this.selectedIndex = this.getSelectedIndex();
        if (command == PCalc.CANCEL_CMD) {
            Display.getDisplay((MIDlet)this.calc).setCurrent(this.parent.parent);
        } else if (command == PCalc.STEP_CMD) {
            if (this.vm.cSp == 0) {
                this.calc.showError("Program is terminated", (Displayable)this);
                return;
            }
            try {
                this.vm.step();
            }
            catch (ArithmeticException arithmeticException) {
                this.calc.showError("Arithmetic exception", (Displayable)this);
                return;
            }
            catch (StackEmptyException stackEmptyException) {
                this.calc.showError("Stack empty", (Displayable)this);
                return;
            }
            catch (StackOverflowException stackOverflowException) {
                this.calc.showError("Stack overflow", (Displayable)this);
                return;
            }
            if (this.vm.currFrame.proc != this.curr) {
                while (this.size() > 0) {
                    this.delete(this.size() - 1);
                }
                this.curr = this.vm.currFrame.proc;
                String[] stringArray = VirtualMachine.printInstructions(this.curr);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.append(stringArray[i], null);
                }
            }
            this.setSelectedIndex(VirtualMachine.getInstructionForPc(this.curr.code, this.vm.currFrame.pc), true);
        } else if (command == PCalc.CONTINUE_CMD) {
            new Monitor(this.calc, this.parent, this.vm);
        } else if (command == PCalc.RESTART_CMD) {
            Display.getDisplay((MIDlet)this.calc).setCurrent((Displayable)this.parent);
        } else if (command == PCalc.VARIABLES_CMD) {
            new InspectVariables(this.calc, (Displayable)this, this.vm.currFrame);
        } else if (command == PCalc.STACK_CMD) {
            new InspectStack(this.calc, this, this.vm);
        } else if (command == PCalc.TRACE_CMD) {
            new BackTrace(this.calc, this, this.vm);
        }
    }
}

