/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;

public class EditProcedure
extends List
implements CommandListener {
    PCalc calc;
    Displayable parent;
    Procedure proc;

    EditProcedure(PCalc pCalc, Displayable displayable, Procedure procedure) {
        super(procedure.name, 3);
        this.calc = pCalc;
        this.parent = displayable;
        this.proc = procedure;
        String[] stringArray = VirtualMachine.printInstructions(procedure);
        for (int i = 0; i < stringArray.length; ++i) {
            this.append(stringArray[i], null);
        }
        this.setCommandListener(this);
        this.addCommand(PCalc.INSERT_CMD);
        this.addCommand(PCalc.EDIT_CMD);
        this.addCommand(PCalc.DELETE_CMD);
        this.addCommand(PCalc.FUNCTIONS_CMD);
        this.addCommand(PCalc.VARIABLES_CMD);
        this.addCommand(PCalc.MOVE_CMD);
        this.addCommand(PCalc.SAVE_CMD);
        Display.getDisplay((MIDlet)pCalc).setCurrent((Displayable)this);
    }

    void redraw() {
        int n = this.getSelectedIndex();
        while (this.size() > 0) {
            this.delete(this.size() - 1);
        }
        String[] stringArray = VirtualMachine.printInstructions(this.proc);
        for (int i = 0; i < stringArray.length; ++i) {
            this.append(stringArray[i], null);
        }
        this.setSelectedIndex(n, true);
    }

    public void commandAction(Command command, Displayable displayable) {
        int n = this.getSelectedIndex();
        if (command == PCalc.SAVE_CMD) {
            Display.getDisplay((MIDlet)this.calc).setCurrent(this.parent);
        } else if (command == PCalc.INSERT_CMD) {
            if (n < this.size() - 1) {
                int n2 = VirtualMachine.getPcForInstruction(this.proc.code, n);
                new SelectCommandGroup(this.calc, this, this.proc, n, n2);
            }
        } else if (command == PCalc.DELETE_CMD) {
            if (n < this.size() - 1) {
                int n3 = VirtualMachine.getPcForInstruction(this.proc.code, n);
                if (n == this.size() - 2) {
                    this.calc.showError("Can not remove last intruction", (Displayable)this);
                } else {
                    this.delete(n);
                    this.proc.removeInstruction(n3);
                }
            }
        } else if (command == PCalc.FUNCTIONS_CMD) {
            new ProcedureList(this.calc, this.parent, this.proc);
        } else if (command == PCalc.VARIABLES_CMD) {
            new VariableList(this.calc, this, this.proc);
        } else if (command == PCalc.MOVE_CMD) {
            if (n < this.size() - 1) {
                int n4 = VirtualMachine.getPcForInstruction(this.proc.code, n);
                String string = this.getString(n);
                if (string.indexOf(58) >= 0) {
                    new MoveLabel(this.calc, this, this.proc, n, n4);
                } else {
                    this.calc.showError("Instruction has no label", (Displayable)this);
                }
            }
        } else if (n < this.size() - 1) {
            int n5 = VirtualMachine.getPcForInstruction(this.proc.code, n);
            switch (this.proc.code[n5]) {
                case 1: 
                case 3: {
                    new ChooseVariable(this.calc, this, this.proc, n, n5, this.proc.code[n5], true);
                    break;
                }
                case 0: {
                    new InputLiteral(this.calc, this, this.proc, n, n5, true);
                    break;
                }
                case 2: {
                    new ChooseInputVariable(this.calc, this, this.proc, n, n5, true);
                    break;
                }
                case 41: {
                    new ChooseFunction(this.calc, this, this.proc, n, n5, true);
                    break;
                }
                case 40: 
                case 43: {
                    new SetLabel(this.calc, this, this.proc, n, n5, this.proc.code[n5], true);
                    break;
                }
                default: {
                    this.calc.showError("Non-editable instruction", (Displayable)this);
                }
            }
        }
    }
}

