/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class Monitor
extends Form
implements CommandListener {
    PCalc calc;
    Launcher parent;
    VirtualMachine vm;
    StringItem item;
    TimerThread timer;
    ExecutorThread executor;
    long startTime;
    volatile boolean terminated;
    static final long SECOND = 1000L;

    Monitor(PCalc pCalc, Launcher launcher, VirtualMachine virtualMachine) {
        super("Running...");
        this.calc = pCalc;
        this.parent = launcher;
        this.vm = virtualMachine;
        this.item = new StringItem("Elapsed time", "0");
        this.append((Item)this.item);
        this.setCommandListener(this);
        this.addCommand(PCalc.STOP_CMD);
        Display.getDisplay((MIDlet)pCalc).setCurrent((Displayable)this);
        this.startTime = System.currentTimeMillis();
        this.timer = new TimerThread();
        this.executor = new ExecutorThread();
        this.timer.start();
        this.executor.start();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == PCalc.STOP_CMD) {
            this.vm.running = false;
            this.terminated = true;
        }
    }

    class ExecutorThread
    extends Thread {
        ExecutorThread() {
        }

        public void run() {
            try {
                Monitor.this.vm.run();
            }
            catch (ArithmeticException arithmeticException) {
                Monitor.this.terminated = true;
                Monitor.this.calc.showError("Arithmetic exception", (Displayable)new Debugger(Monitor.this.calc, Monitor.this.parent, Monitor.this.vm, false));
                return;
            }
            catch (StackEmptyException stackEmptyException) {
                Monitor.this.terminated = true;
                Monitor.this.calc.showError("Stack empty", (Displayable)new Debugger(Monitor.this.calc, Monitor.this.parent, Monitor.this.vm, false));
                return;
            }
            catch (StackOverflowException stackOverflowException) {
                Monitor.this.terminated = true;
                Monitor.this.calc.showError("Stack overflow", (Displayable)new Debugger(Monitor.this.calc, Monitor.this.parent, Monitor.this.vm, false));
                return;
            }
            if (Monitor.this.terminated) {
                new Debugger(Monitor.this.calc, Monitor.this.parent, Monitor.this.vm, true);
            } else {
                long l = System.currentTimeMillis();
                new ShowResults(Monitor.this.calc, Monitor.this.parent, Monitor.this.vm, (int)(l - Monitor.this.startTime));
            }
        }
    }

    class TimerThread
    extends Thread {
        TimerThread() {
        }

        public void run() {
            try {
                while (!Monitor.this.terminated) {
                    Thread.sleep(1000L);
                    long l = System.currentTimeMillis();
                    Monitor.this.item.setText(Integer.toString((int)((l - Monitor.this.startTime) / 1000L)));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

