/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameScreen;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Scroller {
    Image IBack = null;
    Image[] ITiles;
    private static final int MAPMAXSIZE = 100;
    private static final int MAXNOFLAYER1 = 480;
    private static final int NOFTILESETS = 8;
    int PIXELHEIGHT;
    int PIXELWIDTH;
    byte[] b;
    private static final boolean[] bTileSetPersistant = new boolean[]{false, false, false, true, true, false, false, false, false};
    Graphics gBack = null;
    int iMapDXPos;
    int iMapDYPos;
    public int iMapLoaded = -1;
    int iMapTileHe;
    int iMapTileWi;
    int iMapXTilePos;
    int iMapYTilePos;
    public int iNofLayer1;
    int iScrollHe;
    int iScrollWi;
    int iTileHe;
    private int iTileSetLoaded = -1;
    int iTileSize;
    int iTileWi;
    int[] iTilesTileHe;
    int[] iTilesTileWi;
    InputStream is;
    public byte[][] map;
    int mapXTilePos;
    int mapYTilePos;
    public short[] sLayer1 = new short[480];

    public Scroller(int n, int n2, int n3, GameScreen gameScreen) {
        this.ITiles = new Image[8];
        this.iTilesTileWi = new int[8];
        this.iTilesTileHe = new int[8];
        this.b = new byte[100];
        gameScreen.setLoadingBar(30);
        this.PIXELWIDTH = n;
        this.PIXELHEIGHT = n2;
        this.iTileSize = n3;
        int n4 = 0;
        while (n4 < 8) {
            this.iTilesTileWi[n4] = 1;
            this.iTilesTileHe[n4] = 1;
            ++n4;
        }
        this.iScrollWi = (n - 1) / n3 + 2;
        this.iScrollWi *= n3;
        this.iScrollHe = (n2 - 1) / n3 + 2;
        this.iScrollHe *= n3;
        this.iTileWi = this.iScrollWi / n3;
        this.iTileHe = this.iScrollHe / n3;
        gameScreen.setLoadingBar(35);
        try {
            this.IBack = Image.createImage((int)this.iScrollWi, (int)this.iScrollHe);
        }
        catch (Exception exception) {
            System.out.println("Scroller Constructor Exception: " + exception);
        }
        gameScreen.setLoadingBar(40);
        this.gBack = this.IBack.getGraphics();
        gameScreen.setLoadingBar(45);
        this.map = new byte[100][100];
        gameScreen.setLoadingBar(50);
        int n5 = 0;
        while (n5 < 8) {
            this.ITiles[n5] = null;
            ++n5;
        }
        gameScreen.setLoadingBar(55);
    }

    short b2toS(byte n, byte by) {
        int n2 = 0;
        n2 = n < 0 ? 256 + n : n;
        return (short)(n2 += by << 8);
    }

    void down(int n) {
        this.iMapDYPos += n;
        while (this.iMapDYPos >= this.iTileSize) {
            this.iMapDYPos -= this.iTileSize;
            if (this.iMapYTilePos < this.iMapTileHe - this.iTileHe) {
                int n2 = this.iMapXTilePos % this.iTileWi;
                int n3 = this.iMapYTilePos % this.iTileHe;
                int n4 = 0;
                while (n4 < this.iTileWi) {
                    this.drawTile(n2, n3, this.map[this.iMapXTilePos + n4][this.iMapYTilePos + this.iTileHe]);
                    ++n2;
                    n2 %= this.iTileWi;
                    ++n4;
                }
                ++this.iMapYTilePos;
                continue;
            }
            this.iMapDYPos = this.iTileSize - 1;
        }
    }

    private void drawTile(int n, int n2, int n3) {
        this.gBack.setClip(n *= this.iTileSize, n2 *= this.iTileSize, this.iTileSize, this.iTileSize);
        int n4 = n2 - n3 / this.iTilesTileWi[this.iTileSetLoaded] * this.iTileSize;
        int n5 = n - n3 % this.iTilesTileWi[this.iTileSetLoaded] * this.iTileSize;
        this.gBack.drawImage(this.ITiles[this.iTileSetLoaded], n5, n4, 0);
    }

    void left(int n) {
        this.iMapDXPos -= n;
        while (this.iMapDXPos < 0) {
            this.iMapDXPos += this.iTileSize;
            if (this.iMapXTilePos > 0) {
                int n2 = this.iMapYTilePos % this.iTileHe;
                int n3 = (this.iMapXTilePos - 1) % this.iTileWi;
                int n4 = 0;
                while (n4 < this.iTileHe) {
                    this.drawTile(n3, n2, this.map[this.iMapXTilePos - 1][this.iMapYTilePos + n4]);
                    ++n2;
                    n2 %= this.iTileHe;
                    ++n4;
                }
                --this.iMapXTilePos;
                continue;
            }
            this.iMapDXPos = 0;
        }
    }

    void loadMap(int n) {
        if (this.iMapLoaded == n) {
            return;
        }
        this.iMapLoaded = n;
        this.is = this.getClass().getResourceAsStream("/level/" + n + ".m1b");
        if (this.is == null) {
            System.out.println("Could not find map /level/" + n + ".m1b    !!!!!!");
        }
        try {
            this.is.read(this.b, 0, 4);
            this.iMapTileWi = this.b[0];
            this.iMapTileHe = this.b[2];
            int n2 = 0;
            while (n2 < this.iMapTileHe) {
                this.is.read(this.b, 0, this.iMapTileWi);
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.iMapTileWi) {
                    this.map[n4][n2] = this.b[n3++];
                    ++n4;
                }
                ++n2;
            }
            this.is.read(this.b, 0, 2);
            int n5 = this.b2toS(this.b[1], this.b[0]);
            this.iNofLayer1 = 0;
            int n6 = 0;
            while (n6 < n5) {
                this.is.read(this.b, 0, 3);
                this.sLayer1[this.iNofLayer1++] = this.b2toS(this.b[0], (byte)0);
                this.sLayer1[this.iNofLayer1++] = this.b2toS(this.b[1], (byte)0);
                int n7 = this.b2toS(this.b[2], (byte)0) - 43;
                if (n7 < 0) {
                    n7 = 256 + n7;
                }
                this.sLayer1[this.iNofLayer1++] = (short)n7;
                ++n6;
            }
        }
        catch (IOException iOException) {
            System.out.println("LoadMap Exception: " + iOException);
        }
        this.iNofLayer1 /= 3;
    }

    void loadTileSet(int n) {
        if (this.iTileSetLoaded == n) {
            return;
        }
        if (this.iTileSetLoaded != -1 && !bTileSetPersistant[this.iTileSetLoaded]) {
            this.ITiles[this.iTileSetLoaded] = null;
        }
        this.iTileSetLoaded = n;
        if (this.ITiles[this.iTileSetLoaded] != null) {
            return;
        }
        try {
            this.ITiles[this.iTileSetLoaded] = Image.createImage((String)("/gfx/tileset" + this.iTileSetLoaded + ".png"));
        }
        catch (Exception exception) {
            System.out.println("LoadTiles Exception: " + exception);
        }
        this.iTilesTileWi[this.iTileSetLoaded] = this.ITiles[this.iTileSetLoaded].getWidth() / this.iTileSize;
        this.iTilesTileHe[this.iTileSetLoaded] = this.ITiles[this.iTileSetLoaded].getHeight() / this.iTileSize;
    }

    void paint(Graphics graphics, int n, int n2) {
        graphics.setClip(n, n2, this.PIXELWIDTH, this.PIXELHEIGHT);
        graphics.drawImage(this.IBack, n += -(this.iMapXTilePos % this.iTileWi) * this.iTileSize - this.iMapDXPos, n2 += -(this.iMapYTilePos % this.iTileHe) * this.iTileSize - this.iMapDYPos, 0);
        graphics.drawImage(this.IBack, n += this.iScrollWi, n2, 0);
        graphics.drawImage(this.IBack, n, n2 += this.iScrollHe, 0);
        graphics.drawImage(this.IBack, n -= this.iScrollWi, n2, 0);
    }

    void right(int n) {
        this.iMapDXPos += n;
        while (this.iMapDXPos >= this.iTileSize) {
            this.iMapDXPos -= this.iTileSize;
            if (this.iMapXTilePos < this.iMapTileWi - this.iTileWi) {
                int n2 = this.iMapYTilePos % this.iTileHe;
                int n3 = this.iMapXTilePos % this.iTileWi;
                int n4 = 0;
                while (n4 < this.iTileHe) {
                    this.drawTile(n3, n2, this.map[this.iMapXTilePos + this.iTileWi][this.iMapYTilePos + n4]);
                    ++n2;
                    n2 %= this.iTileHe;
                    ++n4;
                }
                ++this.iMapXTilePos;
                continue;
            }
            this.iMapDXPos = this.iTileSize - 1;
        }
    }

    void setScrollerPos(int n, int n2) {
        this.iMapDXPos = n % this.iTileSize;
        this.iMapDYPos = n2 % this.iTileSize;
        this.iMapXTilePos = n / this.iTileSize;
        this.iMapYTilePos = n2 / this.iTileSize;
        this.mapXTilePos = n / this.iTileSize;
        this.mapYTilePos = n2 / this.iTileSize;
        int n3 = this.mapXTilePos % this.iTileWi;
        int n4 = this.mapYTilePos % this.iTileHe;
        int n5 = 0;
        while (n5 < this.iTileHe) {
            int n6 = 0;
            while (n6 < this.iTileWi) {
                this.drawTile(n3, n4, this.map[n6 + this.iMapXTilePos][n5 + this.iMapYTilePos]);
                ++n3;
                n3 %= this.iTileWi;
                ++n6;
            }
            ++n4;
            n4 %= this.iTileHe;
            ++n5;
        }
    }

    void up(int n) {
        this.iMapDYPos -= n;
        while (this.iMapDYPos < 0) {
            this.iMapDYPos += this.iTileSize;
            if (this.iMapYTilePos > 0) {
                int n2 = this.iMapXTilePos % this.iTileWi;
                int n3 = (this.iMapYTilePos - 1) % this.iTileHe;
                int n4 = 0;
                while (n4 < this.iTileWi) {
                    this.drawTile(n2, n3, this.map[this.iMapXTilePos + n4][this.iMapYTilePos - 1]);
                    ++n2;
                    n2 %= this.iTileWi;
                    ++n4;
                }
                --this.iMapYTilePos;
                continue;
            }
            this.iMapDYPos = 0;
        }
    }
}

