/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.dvj2me;

import com.dvidearts.dvj2me.dvMenuOption;
import com.dvidearts.dvj2me.dvPoint;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class dvMenu {
    private boolean active;
    private Vector vec;
    private dvPoint ptPosition;
    private byte justify;
    private byte valign;
    private int top;
    private int left;
    private int width;
    private int height;
    private int cursor;
    private int squeeze;
    public static final byte JUSTIFY_LEFT = 0;
    public static final byte JUSTIFY_CENTER = 1;
    public static final byte JUSTIFY_RIGHT = 2;
    public static final byte VALIGN_TOP = 0;
    public static final byte VALIGN_BOTTOM = 1;

    public dvMenu(byte bJustify, byte bValign) {
        this.justify = bJustify;
        this.valign = bValign;
        this.active = false;
        this.vec = new Vector();
        this.vec.removeAllElements();
        this.width = 0;
        this.height = 0;
        this.top = 0;
        this.left = 0;
        this.ptPosition = new dvPoint();
        this.cursor = 0;
        this.squeeze = 0;
    }

    public void Free() {
        this.ptPosition = null;
        this.vec = null;
    }

    public void setSqueeze(int iSqueeze) {
        this.squeeze = iSqueeze;
    }

    public void removeAllOptions() {
        this.vec.removeAllElements();
        this.active = false;
    }

    public void addOption(dvMenuOption option) {
        this.vec.addElement(option);
    }

    public void addOptionByIndex(dvMenuOption option, int index) {
        if (index < 0 || index > this.vec.size()) {
            this.vec.addElement(option);
            return;
        }
        this.vec.insertElementAt(option, index);
    }

    public int getIdByIndex(int index) {
        if (index < 0 || index > this.vec.size()) {
            return -1;
        }
        dvMenuOption lt = (dvMenuOption)this.vec.elementAt(index);
        if (lt == null) {
            return -1;
        }
        return lt.getId();
    }

    public void removeOption(dvMenuOption option) {
        Enumeration e = this.vec.elements();
        dvMenuOption lt = null;
        while (e.hasMoreElements()) {
            lt = (dvMenuOption)e.nextElement();
            if (lt == null || lt != option) continue;
            this.vec.removeElement(option);
        }
        e = null;
    }

    public void swapOption(dvMenuOption replaceThis, dvMenuOption withThis) {
        Enumeration e = this.vec.elements();
        dvMenuOption lt = null;
        int i = 0;
        while (e.hasMoreElements()) {
            lt = (dvMenuOption)e.nextElement();
            if (lt != null && lt == replaceThis) {
                this.vec.removeElement(replaceThis);
                this.vec.insertElementAt(withThis, i);
            }
            ++i;
        }
        e = null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setPosition(int iX, int iY) {
        this.ptPosition.set(iX, iY);
    }

    public dvPoint getPosition() {
        return this.ptPosition;
    }

    public void show(boolean val) {
        this.cursor = 0;
        this.active = val;
    }

    public void paint(Graphics g) {
        int boxW;
        if (!this.active) {
            return;
        }
        int size = this.vec.size();
        if (size == 0) {
            return;
        }
        dvMenuOption lt = (dvMenuOption)this.vec.elementAt(0);
        if (lt == null) {
            return;
        }
        int boxX = 0;
        this.width = boxW = lt.getUnselectedWidth();
        switch (this.justify) {
            case 0: {
                boxX = this.ptPosition.x;
                break;
            }
            case 1: {
                boxX = this.ptPosition.x - boxW / 2;
                break;
            }
            case 2: {
                boxX = this.ptPosition.x - boxW - 1;
            }
        }
        Enumeration e = this.vec.elements();
        int i = 0;
        int tmpH = 0;
        this.height = 0;
        while (e.hasMoreElements()) {
            lt = (dvMenuOption)e.nextElement();
            this.height += lt.getUnselectedHeight();
            switch (this.valign) {
                case 0: {
                    tmpH = this.ptPosition.y + i * lt.getUnselectedHeight();
                    tmpH -= this.squeeze * i;
                    break;
                }
                case 1: {
                    tmpH = this.ptPosition.y - (i + 1) * lt.getUnselectedHeight();
                    tmpH += this.squeeze * i;
                }
            }
            lt.setPosition(boxX, tmpH);
            lt.paint(g, false);
            ++i;
        }
        this.height = -(this.squeeze * (size - 1));
        e = null;
        lt = (dvMenuOption)this.vec.elementAt(this.cursor);
        if (lt != null && lt.getSelectedWidth() > 0) {
            lt.paint(g, true);
        }
    }

    private void cursorBack() {
        --this.cursor;
        if (this.cursor < 0) {
            this.cursor = this.vec.size() - 1;
        }
    }

    private void cursorNext() {
        ++this.cursor;
        if (this.cursor >= this.vec.size()) {
            this.cursor = 0;
        }
    }

    public int keyReleased(int gameAction) {
        switch (gameAction) {
            case 5: 
            case 6: {
                switch (this.valign) {
                    case 0: {
                        this.cursorNext();
                        break;
                    }
                    case 1: {
                        this.cursorBack();
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                switch (this.valign) {
                    case 0: {
                        this.cursorBack();
                        break;
                    }
                    case 1: {
                        this.cursorNext();
                    }
                }
                break;
            }
            case 8: {
                return this.cursor;
            }
        }
        return -1;
    }

    public int getSelected() {
        return this.cursor;
    }
}

