/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.dvj2me;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class dvStringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char m = '\u0000';
        int i = 0;
        while (i < this.delimiters.length()) {
            char c = this.delimiters.charAt(i);
            if (m < c) {
                m = c;
            }
            ++i;
        }
        this.maxDelimChar = m;
    }

    public dvStringTokenizer(String str, String delim, boolean returnDelims) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retDelims = returnDelims;
        this.setMaxDelimChar();
    }

    public dvStringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public dvStringTokenizer(String str) {
        this(str, " \t\n\r\f", false);
    }

    private int skipDelimiters(int startPos) {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int position = startPos;
        while (!this.retDelims && position < this.maxPosition) {
            char c = this.str.charAt(position);
            if (c > this.maxDelimChar || this.delimiters.indexOf(c) < 0) break;
            ++position;
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c;
        int position = startPos;
        while (position < this.maxPosition) {
            c = this.str.charAt(position);
            if (c <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) break;
            ++position;
        }
        if (this.retDelims && startPos == position && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(start, this.currentPosition);
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition) {
            if ((currpos = this.skipDelimiters(currpos)) >= this.maxPosition) break;
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }
}

