/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.dvj2me.dvSprite;
import com.dvidearts.dvj2me.dvTile;

public class Ghost
extends dvSprite {
    byte health;
    byte mAnimation = (byte)-1;
    byte state;
    short deathClock;
    short castFrame;
    short wx;
    short wy;
    short sx;
    short sy;
    short shadx;
    short shady;
    boolean active;
    boolean onscreen;
    private Game game;
    private int xo;
    private int yo;

    public Ghost(Game g) {
        super(g.sprGhost);
        this.game = g;
        this.wx = 0;
        this.wy = 0;
        this.active = false;
        this.deathClock = 0;
        this.health = 0;
        this.xo = this.getWidth() / 2;
        this.yo = this.getHeight() - this.getHeight() / 3;
    }

    void update(Player p) {
        if (this.game.dvpopup.IsActive()) {
            return;
        }
        this.onscreen = false;
        this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
        this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
        this.setPosition(this.sx, this.sy);
        this.onscreen = this.isOnScreen(this.game.x, this.game.y, this.game.resw, this.game.resh);
        if (this.game.wipe.IsActive()) {
            return;
        }
        if (this.health > 0 && (this.onscreen || this.state == 2)) {
            if (this.state != 2) {
                if (this.game.sinfo[this.game.infoSlot].currTileMap == 16) {
                    this.setAnimation((byte)14);
                    this.state = (byte)2;
                    this.castFrame = 0;
                } else {
                    if (this.state != 1 || p.wx >= this.wx + this.game.GHOST_ATTACK_RANGE1 || p.wx < this.wx - this.game.GHOST_ATTACK_RANGE1 || p.wy >= this.wy + this.game.GHOST_ATTACK_RANGE1 || p.wy < this.wy - this.game.GHOST_ATTACK_RANGE1) {
                        this.state = 0;
                    }
                    if (p.wx < this.wx + this.game.GHOST_ATTACK_RANGE2 && p.wx >= this.wx - this.game.GHOST_ATTACK_RANGE2 && p.wy < this.wy + this.game.GHOST_ATTACK_RANGE2 && p.wy >= this.wy - this.game.GHOST_ATTACK_RANGE2) {
                        this.state = 1;
                    }
                    if (p.wx < this.wx + this.game.GHOST_ATTACK_RANGE3 && p.wx >= this.wx - this.game.GHOST_ATTACK_RANGE3 && p.wy < this.wy + this.game.GHOST_ATTACK_RANGE3 && p.wy >= this.wy - this.game.GHOST_ATTACK_RANGE3) {
                        this.setAnimation((byte)14);
                        this.state = (byte)2;
                        this.castFrame = 0;
                    }
                }
            }
            short tx = this.wx;
            short ty = this.wy;
            short cellid = 0;
            int runspeed = this.game.TILEW / 16;
            switch (this.state) {
                case 2: {
                    if (this.castFrame == 0) {
                        this.shadx = (short)(p.wx - this.xo);
                        this.shady = (short)(p.wy - this.yo);
                    }
                    if (this.castFrame > 30) {
                        this.state = 0;
                    }
                    this.castFrame = (short)(this.castFrame + 1);
                    if (this.onscreen) break;
                    return;
                }
                case 0: {
                    this.setAnimation((byte)0);
                    break;
                }
                case 1: {
                    boolean moving = false;
                    int px = p.wx - 8;
                    int py = p.wy - this.yo;
                    if (px < this.wx) {
                        this.wx = this.wx - px < runspeed ? (short)px : (short)(this.wx - runspeed);
                        this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
                        this.setPosition(this.sx, this.sy);
                        moving = true;
                        this.setAnimation((byte)12);
                        cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo));
                        if (this.game.world.collideSolid(cellid, this)) {
                            this.wx = tx;
                            this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
                            this.setPosition(this.sx, this.sy);
                        }
                    } else if (px > this.wx) {
                        this.wx = px - this.wx < runspeed ? (short)px : (short)(this.wx + runspeed);
                        this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
                        this.setPosition(this.sx, this.sy);
                        moving = true;
                        this.setAnimation((byte)13);
                        cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo));
                        if (this.game.world.collideSolid(cellid, this)) {
                            this.wx = tx;
                            this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
                            this.setPosition(this.sx, this.sy);
                        }
                    }
                    if (py < this.wy) {
                        this.wy = this.wy - py < runspeed ? (short)py : (short)(this.wy - runspeed);
                        this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
                        this.setPosition(this.sx, this.sy);
                        if (!moving) {
                            this.setAnimation((byte)11);
                        }
                        if (!this.game.world.collideSolid(cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo)), this)) break;
                        this.wy = ty;
                        this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
                        this.setPosition(this.sx, this.sy);
                        break;
                    }
                    if (py <= this.wy) break;
                    this.wy = py - this.wy < runspeed ? (short)py : (short)(this.wy + runspeed);
                    this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
                    this.setPosition(this.sx, this.sy);
                    if (!moving) {
                        this.setAnimation((byte)10);
                    }
                    if (!this.game.world.collideSolid(cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo)), this)) break;
                    this.wy = ty;
                    this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
                    this.setPosition(this.sx, this.sy);
                }
            }
            if (!p.invinsible && p.collidesWith(this, (int)this.sx, (int)this.sy)) {
                p.invinsible = true;
                this.game.sinfo[this.game.infoSlot].health = (byte)(this.game.sinfo[this.game.infoSlot].health - 1);
            }
            tx = this.wx;
            ty = this.wy;
            if (p.getFrame() == 0) {
                switch (p.mAnimation) {
                    case 6: {
                        if (!p.sword.collidesWith(this, (int)this.sx, (int)this.sy) && !p.collidesWith(this, (int)this.sx, (int)this.sy)) break;
                        this.health = (byte)(this.health - p.getSwordDamage());
                        if (this.health >= 1) break;
                        p.addMagic();
                        p.dropHeart(this.wx, this.wy);
                        return;
                    }
                    case 5: {
                        if (!p.sword.collidesWith(this, (int)this.sx, (int)this.sy) && !p.collidesWith(this, (int)this.sx, (int)this.sy)) break;
                        this.health = (byte)(this.health - p.getSwordDamage());
                        if (this.health >= 1) break;
                        p.addMagic();
                        p.dropHeart(this.wx, this.wy);
                        return;
                    }
                    case 7: {
                        if (!p.sword.collidesWith(this, (int)this.sx, (int)this.sy) && !p.collidesWith(this, (int)this.sx, (int)this.sy)) break;
                        this.health = (byte)(this.health - p.getSwordDamage());
                        if (this.health >= 1) break;
                        p.addMagic();
                        p.dropHeart(this.wx, this.wy);
                        return;
                    }
                    case 8: {
                        if (!p.sword.collidesWith(this, (int)this.sx, (int)this.sy) && !p.collidesWith(this, (int)this.sx, (int)this.sy)) break;
                        this.health = (byte)(this.health - p.getSwordDamage());
                        if (this.health >= 1) break;
                        p.addMagic();
                        p.dropHeart(this.wx, this.wy);
                        return;
                    }
                }
            }
            this.nextFrame();
        } else if (this.health < 1) {
            this.health = 0;
            if (this.game.sinfo[this.game.infoSlot].currTileMap == 16) {
                return;
            }
            this.deathClock = (short)(this.deathClock + 1);
            if (this.deathClock > 300) {
                this.reset();
            }
        }
    }

    void move(int x, int y) {
        this.wx = (short)x;
        this.wy = (short)y;
    }

    void moveCell(int x, int y, dvTile map) {
        this.wx = (short)(map.getCellWidth() * x);
        this.wy = (short)(map.getCellHeight() * y);
    }

    void reset() {
        switch (this.game.sinfo[this.game.infoSlot].swordLevel) {
            case 0: {
                this.health = (byte)5;
                break;
            }
            case 1: {
                this.health = (byte)4;
                break;
            }
            case 2: {
                this.health = (byte)3;
                break;
            }
            case 3: {
                this.health = (byte)2;
                break;
            }
            case 4: {
                this.health = 1;
            }
        }
        this.active = true;
        this.state = 0;
        this.deathClock = 0;
        this.setAnimation((byte)0);
    }

    void setAnimation(byte newAnimation) {
        if (newAnimation == this.mAnimation) {
            return;
        }
        this.setFrame(0);
        switch (newAnimation) {
            case 0: {
                this.setFrameSequence(Gameplay.FRAMES_STAND);
                break;
            }
            case 12: {
                this.setFrameSequence(Gameplay.FRAMES_FLOATLEFT);
                break;
            }
            case 13: {
                this.setFrameSequence(Gameplay.FRAMES_FLOATRIGHT);
                break;
            }
            case 11: {
                this.setFrameSequence(Gameplay.FRAMES_FLOATUP);
                break;
            }
            case 10: {
                this.setFrameSequence(Gameplay.FRAMES_FLOATDOWN);
                break;
            }
            case 14: {
                this.setFrameSequence(Gameplay.FRAMES_CASTSPELL);
            }
        }
        this.mAnimation = newAnimation;
    }
}

